/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.controller;

import com.zhyc.xps.aqpt.dto.ChecklistHazardRiskPositionDto;
import com.zhyc.xps.aqpt.service.ChecklistHazardRiskPositionService;
import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.exception.CustomException;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ent/risk/position"})
public class EntHazardRiskPositionController
extends BaseController {
    @Resource
    ChecklistHazardRiskPositionService riskPositionService;

    @GetMapping(value={""})
    public JsonResult getRiskCtrlPositionByList(@RequestParam Map<String, Object> map) {
        Long ocId;
        Long checklistId = ocId = this.getCurOcId();
        map.put("ocId", ocId);
        map.put("checklistId", checklistId);
        List<ChecklistHazardRiskPositionDto> data = this.riskPositionService.getRiskPositionByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @PostMapping(value={"/{hazardId}/{riskId}/{positionId}"})
    public JsonResult createOrUpdateRiskCtrlPosition(@PathVariable Long hazardId, @PathVariable Long riskId, @PathVariable Long positionId) throws CustomException {
        Long ocId;
        Long checklistId = ocId = this.getCurOcId();
        try {
            this.riskPositionService.createRiskPosition(ocId, checklistId, hazardId, riskId, positionId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @DeleteMapping(value={"/{hazardId}/{riskId}/{positionId}"})
    public JsonResult deleteRiskPositionById(@PathVariable Long hazardId, @PathVariable Long riskId, @PathVariable Long positionId) throws CustomException {
        Long ocId;
        Long checklistId = ocId = this.getCurOcId();
        try {
            this.riskPositionService.deleteRiskPositionById(ocId, checklistId, hazardId, riskId, positionId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

