/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.controller;

import com.zhyc.xps.aqpt.dto.EntRiskPointArtDto;
import com.zhyc.xps.aqpt.entity.EntRiskPointArt;
import com.zhyc.xps.aqpt.service.EntRiskPointArtService;
import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import com.zhyc.xps.sys.dto.ArtDto;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ent/riskPoint/art"})
public class EntRiskPointArtController
extends BaseController {
    @Resource
    EntRiskPointArtService riskPointArtService;

    @GetMapping(value={"/page"})
    public PageResult getRiskPointArtByPage(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        PageBean<EntRiskPointArtDto> data = this.riskPointArtService.getRiskPointArtByPage(map);
        return this.pageResult(data);
    }

    @GetMapping(value={"/{riskPointId}"})
    public JsonResult getRiskPointArtByList(@PathVariable Long riskPointId) {
        Long ocId = this.getCurOcId();
        List<EntRiskPointArtDto> data = this.riskPointArtService.getRiskPointArtByList(ocId, riskPointId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @PostMapping(value={"/add"})
    public JsonResult createRiskPointArt(@RequestBody EntRiskPointArt riskPointArt) throws CustomException {
        Long ocId = this.getCurOcId();
        try {
            riskPointArt.setOcId(ocId);
            this.riskPointArtService.createRiskPointArt(riskPointArt);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @DeleteMapping(value={"/{riskPointId}/{artId}"})
    public JsonResult deleteRiskPointArt(@PathVariable Long riskPointId, @PathVariable Long artId) throws CustomException {
        Long ocId = this.getCurOcId();
        try {
            this.riskPointArtService.deleteRiskPointArt(ocId, riskPointId, artId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/select/page"})
    public PageResult getArtSelectByPage(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        PageBean<ArtDto> data = this.riskPointArtService.getArtSelectByPage(map);
        return this.pageResult(data);
    }
}

