/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.controller;

import com.zhyc.xps.aqpt.entity.EntRiskPointCat;
import com.zhyc.xps.aqpt.service.EntRiskPointCatService;
import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ent/riskPoint/cat"})
public class EntRiskPointCatController
extends BaseController {
    @Resource
    EntRiskPointCatService riskPointCatService;

    @GetMapping(value={"/page"})
    public PageResult getRiskPointCatByPage(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        PageBean<EntRiskPointCat> pageInfo = this.riskPointCatService.getRiskPointCatByPage(map);
        return this.pageResult(pageInfo);
    }

    @GetMapping(value={"/{riskPointCatId}"})
    public JsonResult getRiskPointCatById(@PathVariable Long riskPointCatId) {
        Long ocId = this.getCurOcId();
        EntRiskPointCat riskPointCat = this.riskPointCatService.getRiskPointCatById(ocId, riskPointCatId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", (Object)riskPointCat);
    }

    @GetMapping(value={""})
    public JsonResult getRiskPointCatByList(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        List<EntRiskPointCat> data = this.riskPointCatService.getRiskPointCatByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @PostMapping(value={"/add"})
    public JsonResult createRiskPointCat(@RequestBody EntRiskPointCat riskPointCat) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        try {
            riskPointCat.setOcId(ocId);
            riskPointCat.setCreatedBy(userId);
            this.riskPointCatService.createRiskPointCat(riskPointCat);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @PutMapping(value={"/update"})
    public JsonResult updateRiskPointCat(@RequestBody EntRiskPointCat riskPointCat) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        try {
            riskPointCat.setOcId(ocId);
            riskPointCat.setUpdatedBy(userId);
            this.riskPointCatService.updateRiskPointCat(riskPointCat);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{riskPointCatId}"})
    public JsonResult deleteRiskPointCatById(@PathVariable Long riskPointCatId) throws CustomException {
        Long ocId = this.getCurOcId();
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("ocId", ocId);
            map.put("riskPointCatId", riskPointCatId);
            this.riskPointCatService.deleteRiskPointCat(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

