/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.controller;

import com.zhyc.xps.aqpt.dto.EntRiskPointChecklistDto;
import com.zhyc.xps.aqpt.entity.EntRiskPointChecklist;
import com.zhyc.xps.aqpt.service.EntRiskPointChecklistService;
import com.zhyc.xps.aqpt.vo.HazardChecklistVo;
import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.ChecklistDto;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ent/riskPoint/checklist"})
public class EntRiskPointChecklistController
extends BaseController {
    @Resource
    EntRiskPointChecklistService riskPointChecklistService;

    @GetMapping(value={"/page"})
    public PageResult getRiskPointChecklistByPage(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        PageBean<EntRiskPointChecklistDto> data = this.riskPointChecklistService.getRiskPointChecklistByPage(map);
        return this.pageResult(data);
    }

    @GetMapping(value={""})
    public JsonResult getRiskPointChecklistByList(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        List<EntRiskPointChecklistDto> data = this.riskPointChecklistService.getRiskPointChecklistByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/select/page"})
    public PageResult getSelectChecklistByPage(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        PageBean<ChecklistDto> data = this.riskPointChecklistService.getSelectChecklistByPage(map);
        return this.pageResult(data);
    }

    @PostMapping(value={"/add"})
    public JsonResult createRiskPointChecklist(@RequestBody EntRiskPointChecklist riskPointChecklist) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        try {
            riskPointChecklist.setOcId(ocId);
            riskPointChecklist.setCreatedBy(userId);
            this.riskPointChecklistService.createRiskPointChecklist(riskPointChecklist);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @DeleteMapping(value={"/{riskPointId}/{checklistId}"})
    public JsonResult deleteRiskPointChecklistById(@PathVariable Long riskPointId, @PathVariable Long checklistId) throws CustomException {
        Long ocId = this.getCurOcId();
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("ocId", ocId);
            map.put("riskPointId", riskPointId);
            map.put("checklistId", checklistId);
            this.riskPointChecklistService.deleteRiskPointChecklist(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/view/{riskPointId}/{checklistId}"})
    public JsonResult getRiskPointChecklistViewById(@PathVariable Long riskPointId, @PathVariable Long checklistId) {
        Long ocId = this.getCurOcId();
        HazardChecklistVo vo = this.riskPointChecklistService.getRiskPointChecklistViewById(ocId, riskPointId, checklistId);
        if (ObjectUtils.isEmpty((Object)vo)) {
            return this.resultErr("\u6e05\u5355\u4e0d\u5b58\u5728");
        }
        return this.resultOk("\u83b7\u53d6\u6210\u529f", vo);
    }
}

