/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.controller;

import com.zhyc.xps.aqpt.dto.EquipmentCatDto;
import com.zhyc.xps.aqpt.entity.EquipmentCat;
import com.zhyc.xps.aqpt.service.EquipmentCatService;
import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/equipment/cat"})
public class EquipmentCatController
extends BaseController {
    @Resource
    EquipmentCatService equipmentCatService;

    @GetMapping(value={""})
    public JsonResult getEquipmentCatByList(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        List<EquipmentCatDto> data = this.equipmentCatService.getEquipmentCatByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/page"})
    public PageResult getEquipmentByPage(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        PageBean<EquipmentCatDto> pageInfo = this.equipmentCatService.getEquipmentCatByPage(map);
        return this.pageResult(pageInfo);
    }

    @GetMapping(value={"/{equipCatId}"})
    public JsonResult getEquipmentCatById(@PathVariable Long equipCatId) {
        Long ocId = this.getCurOcId();
        EquipmentCatDto cat = this.equipmentCatService.getEquipmentCatById(ocId, equipCatId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", cat);
    }

    @PostMapping(value={"/add"})
    public JsonResult createEquipmentCat(@RequestBody EquipmentCat equipmentCat) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        try {
            equipmentCat.setOcId(ocId);
            equipmentCat.setCreatedBy(userId);
            this.equipmentCatService.createEquipmentCat(equipmentCat);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @PutMapping(value={"/update"})
    public JsonResult updateEquipmentCat(@RequestBody EquipmentCat equipmentCat) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        try {
            equipmentCat.setOcId(ocId);
            equipmentCat.setUpdatedBy(userId);
            this.equipmentCatService.updateEquipmentCat(equipmentCat);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{equipCatId}"})
    public JsonResult deleteEquipmentCatById(@PathVariable Long equipCatId) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("ocId", ocId);
            map.put("equipCatId", equipCatId);
            map.put("deletedBy", userId);
            this.equipmentCatService.deleteEquipmentCat(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

