/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.controller;

import com.zhyc.xps.aqpt.dto.EquipmentDto;
import com.zhyc.xps.aqpt.dto.EquipmentMapLayerDto;
import com.zhyc.xps.aqpt.entity.Equipment;
import com.zhyc.xps.aqpt.service.EquipmentService;
import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import com.zhyc.xps.sys.service.EntMapLayerService;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/equipment"})
public class EquipmentController
extends BaseController {
    @Resource
    EquipmentService equipmentService;
    @Resource
    EntMapLayerService mapLayerService;

    @GetMapping(value={"/page"})
    public PageResult getEquipmentByPage(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        PageBean<EquipmentDto> pageInfo = this.equipmentService.getEquipmentByPage(map);
        return this.pageResult(pageInfo);
    }

    @GetMapping(value={""})
    public JsonResult getEquipmentByList(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        List<EquipmentDto> data = this.equipmentService.getEquipmentByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/{equipId}"})
    public JsonResult getEquipmentById(@PathVariable Long equipId) {
        Long ocId = this.getCurOcId();
        EquipmentDto data = this.equipmentService.getEquipmentById(ocId, equipId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @PostMapping(value={"/add"})
    public JsonResult createEquipment(@RequestBody Equipment equipment) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        try {
            equipment.setOcId(ocId);
            equipment.setCreatedBy(userId);
            this.equipmentService.createEquipment(equipment);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @PutMapping(value={"/update"})
    public JsonResult updateEquipment(@RequestBody Equipment equipment) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        try {
            equipment.setOcId(ocId);
            equipment.setUpdatedBy(userId);
            this.equipmentService.updateEquipment(equipment);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{equipId}"})
    public JsonResult deleteEquipmentById(@PathVariable Long equipId) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("ocId", ocId);
            map.put("equipId", equipId);
            map.put("deletedBy", userId);
            this.equipmentService.deleteEquipment(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/updateMapLayer"})
    public JsonResult updateEquipmentMapLayer(@RequestBody EquipmentMapLayerDto equipmentMapLayerDto) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        try {
            equipmentMapLayerDto.setOcId(ocId);
            equipmentMapLayerDto.setUpdatedBy(userId);
            this.equipmentService.updateEquipmentMapLayer(equipmentMapLayerDto);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u66f4\u65b0\u6210\u529f");
    }
}

