/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.controller;

import com.zhyc.xps.aqpt.dto.MeasureTypeDto;
import com.zhyc.xps.aqpt.entity.MeasureType;
import com.zhyc.xps.aqpt.service.MeasureTypeService;
import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.exception.CustomException;
import jakarta.annotation.Resource;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/measure/type"})
public class MeasureTypeController
extends BaseController {
    @Resource
    MeasureTypeService measureTypeService;

    @GetMapping(value={""})
    public JsonResult getMeasureTypeList() {
        List<MeasureTypeDto> data = this.measureTypeService.getMeasureTypeList();
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/{measureTypeId}"})
    public JsonResult getMeasureTypeById(@PathVariable Long measureTypeId) {
        MeasureTypeDto data = this.measureTypeService.getMeasureTypeById(measureTypeId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @PostMapping(value={"/add"})
    public JsonResult createMeasureType(@RequestBody MeasureType measureType) throws CustomException {
        try {
            this.measureTypeService.createMeasureType(measureType);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @PutMapping(value={"/update"})
    public JsonResult updateMeasureType(@RequestBody MeasureType measureType) throws CustomException {
        try {
            this.measureTypeService.updateMeasureType(measureType);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @DeleteMapping(value={"/{measureTypeId}"})
    public JsonResult deleteMeasureTypeById(@PathVariable Long measureTypeId) throws CustomException {
        try {
            this.measureTypeService.deleteMeasureTypeById(measureTypeId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

