/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.controller;

import com.zhyc.xps.aqpt.dto.AlertDto;
import com.zhyc.xps.aqpt.dto.EntDangerDto;
import com.zhyc.xps.aqpt.service.AlertService;
import com.zhyc.xps.aqpt.service.ReportService;
import com.zhyc.xps.aqpt.vo.ChecklistHazardDutyVo;
import com.zhyc.xps.aqpt.vo.ChecklistHazardVo;
import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.sys.service.EntGridService;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/report"})
public class ReportController
extends BaseController {
    @Resource
    private ReportService reportService;
    @Resource
    private AlertService alertService;
    @Resource
    private EntGridService gridService;

    @GetMapping(value={"/grid"})
    public PageResult getGridByPage(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        PageBean pageInfo = this.gridService.getGridByPage(map);
        return this.pageResult(pageInfo);
    }

    @GetMapping(value={"/danger"})
    public PageResult getDangerReport(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        PageBean<EntDangerDto> data = this.reportService.getDangerByPage(map);
        return this.pageResult(data);
    }

    @GetMapping(value={"/duty"})
    public JsonResult getDutyChecklist(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        List<ChecklistHazardDutyVo> data = this.reportService.getRiskPointHazardDutyViewByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/alert"})
    public PageResult getAlertInsByPage(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        PageBean<AlertDto> pageInfo = this.alertService.getAlertByPage(map);
        return this.pageResult(pageInfo);
    }

    @GetMapping(value={"/measure"})
    public JsonResult getMeasureChecklist(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        List<ChecklistHazardVo> data = this.reportService.getRiskPointHazardViewByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }
}

