/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.controller;

import com.zhyc.xps.aqpt.dto.SnapshotDto;
import com.zhyc.xps.aqpt.service.SnapshotService;
import com.zhyc.xps.aqpt.vo.SnapshotVo;
import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import jakarta.annotation.Resource;
import java.util.Map;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/snapshot"})
public class SnapshotController
extends BaseController {
    @Resource
    SnapshotService snapshotService;

    @GetMapping(value={"/page"})
    public PageResult getSnapshotByPage(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        PageBean<SnapshotDto> data = this.snapshotService.getSnapshotByPage(map);
        return this.pageResult(data);
    }

    @GetMapping(value={"/{snapshotId}"})
    public JsonResult getSnapshotById(@PathVariable Long snapshotId) {
        Long ocId = this.getCurOcId();
        SnapshotDto data = this.snapshotService.getSnapshotById(ocId, snapshotId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", (Object)data);
    }

    @PostMapping(value={"/add"})
    public JsonResult createSnapshot(@RequestBody SnapshotVo vo) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        Long groupId = this.getCurUserGroupId();
        Long positionId = this.getCurUserPositionId();
        vo.setOcId(ocId);
        vo.setAccountId(userId);
        vo.setGroupId(groupId);
        vo.setPositionId(positionId);
        try {
            this.snapshotService.createSnapshotData(vo);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @PostMapping(value={"/update"})
    public JsonResult updateSnapshot(@RequestBody SnapshotVo vo) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        Long groupId = this.getCurUserGroupId();
        Long positionId = this.getCurUserPositionId();
        Long snapshotId = vo.getSnapshotId();
        SnapshotDto snapshotDto = this.snapshotService.getSnapshotById(ocId, snapshotId);
        if (ObjectUtils.isEmpty((Object)((Object)snapshotDto))) {
            return this.resultErr("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        Long editorId = snapshotDto.getSubmitAccountId();
        if (!userId.equals(editorId)) {
            return this.resultErr("\u65e0\u6743\u7f16\u8f91");
        }
        try {
            vo.setOcId(ocId);
            vo.setGroupId(groupId);
            vo.setAccountId(userId);
            vo.setPositionId(positionId);
            this.snapshotService.updateSnapshotData(vo);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{snapshotId}"})
    public JsonResult deleteSnapshotById(@PathVariable Long snapshotId) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        SnapshotDto snapshotDto = this.snapshotService.getSnapshotById(ocId, snapshotId);
        if (ObjectUtils.isEmpty((Object)((Object)snapshotDto))) {
            return this.resultErr("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        Long editorId = snapshotDto.getSubmitAccountId();
        if (!userId.equals(editorId)) {
            return this.resultErr("\u65e0\u6743\u7f16\u8f91");
        }
        try {
            this.snapshotService.deleteSnapshotById(ocId, snapshotId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

