/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.service.impl;

import com.github.pagehelper.PageHelper;
import com.zhyc.xps.aqpt.dto.AlertDto;
import com.zhyc.xps.aqpt.entity.Alert;
import com.zhyc.xps.aqpt.mapper.AlertMapper;
import com.zhyc.xps.aqpt.service.AlertService;
import com.zhyc.xps.aqpt.vo.AlertVo;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.service.BaseService;
import com.zhyc.xps.common.utils.IdGenerator.IdKit;
import com.zhyc.xps.common.vo.TaskUserVo;
import com.zhyc.xps.sys.dto.GroupDto;
import com.zhyc.xps.sys.mapper.GroupMapper;
import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
@Transactional
public class AlertServiceImpl
extends BaseService
implements AlertService {
    @Resource
    AlertMapper alertMapper;
    @Resource
    GroupMapper groupMapper;

    @Override
    public PageBean<AlertDto> getAlertByPage(Map<String, Object> map) {
        int page = Integer.parseInt("0" + map.get("page"));
        int limit = Integer.parseInt("0" + map.get("limit"));
        if (map.containsKey("groupId")) {
            Long groupId;
            Long ocId = Long.parseLong("0" + map.get("ocId"));
            GroupDto group = this.groupMapper.getById(ocId, groupId = Long.valueOf(Long.parseLong("0" + map.get("groupId"))));
            if (!ObjectUtils.isEmpty((Object)group)) {
                Long nodeLeft = group.getNodeLeft();
                Long nodeRight = group.getNodeRight();
                map.put("nodeLeft", nodeLeft);
                map.put("nodeRight", nodeRight);
            }
            map.remove("groupId");
        }
        PageHelper.startPage((int)page, (int)limit);
        List<AlertDto> list = this.alertMapper.getByPage(map);
        return new PageBean(list);
    }

    @Override
    public List<AlertDto> getAlertByList(Map<String, Object> map) {
        Long groupId;
        Long ocId;
        GroupDto group;
        if (map.containsKey("groupId") && !ObjectUtils.isEmpty((Object)(group = this.groupMapper.getById(ocId = Long.valueOf(Long.parseLong("0" + map.get("ocId"))), groupId = Long.valueOf(Long.parseLong("0" + map.get("groupId"))))))) {
            Long nodeLeft = group.getNodeLeft();
            Long nodeRight = group.getNodeRight();
            map.put("nodeLeft", nodeLeft);
            map.put("nodeRight", nodeRight);
            map.remove("groupId");
        }
        return this.alertMapper.getByList(map);
    }

    @Override
    public AlertDto getAlertById(Long ocId, Long alertId) {
        return this.alertMapper.getById(ocId, alertId);
    }

    @Override
    public void createAlert(Alert alert) throws Exception {
        Long alertId = alert.getAlertId();
        if (alertId == null) {
            alertId = IdKit.getId();
        }
        alert.setAlertId(alertId);
        alert.setAlertTime(LocalDateTime.now());
        alert.setCreatedAt(LocalDateTime.now());
        this.alertMapper.create(alert);
    }

    @Override
    public void updateAlert(Alert alert) throws Exception {
        alert.setUpdatedAt(LocalDateTime.now());
        this.alertMapper.update(alert);
    }

    @Override
    public void deleteAlert(Map<String, Object> map) throws Exception {
        map.put("deletedFlag", 1);
        map.put("deletedAt", LocalDateTime.now());
        this.alertMapper.delete(map);
    }

    @Override
    public void handleAlert(TaskUserVo user, AlertVo vo) throws Exception {
        Long ocId = user.getOcId();
        Long userId = user.getAccountId();
        Long alertId = vo.getAlertId();
        String formCode = vo.getFormCode();
        Long status = vo.getStatus();
        Alert alert = new Alert();
        alert.setOcId(ocId);
        alert.setAlertId(alertId);
        alert.setStatus(status);
        if ("submit".equals(formCode)) {
            alert.setAlertTitle(vo.getAlertTitle());
            alert.setAlertLevel(vo.getAlertLevel());
            alert.setAlertDesc(vo.getAlertDesc());
            alert.setAlertSource(vo.getAlertSource());
            alert.setAlertTypeId(vo.getAlertTypeId());
            alert.setAlertCode(vo.getAlertCode());
            alert.setRiskPointId(vo.getRiskPointId());
            alert.setAlertTime(LocalDateTime.now());
        } else if ("handle".equals(formCode)) {
            alert.setHandleAccountId(userId);
            alert.setHandlePositionId(user.getPositionId());
            alert.setHandleGroupId(user.getGroupId());
            alert.setHandleAccountName(user.getAccountName());
            alert.setHandlePositionName(user.getPositionName());
            alert.setHandleGroupName(user.getGroupName());
            alert.setHandleTime(LocalDateTime.now());
            alert.setHandleMeasure(vo.getHandleMeasure());
            alert.setHandleAct(vo.getHandleAct());
            alert.setAlertReason(vo.getAlertReason());
        }
        AlertDto dto = this.alertMapper.getById(ocId, alertId);
        if (ObjectUtils.isEmpty((Object)dto)) {
            alert.setCreatedBy(userId);
            alert.setCreatedAt(LocalDateTime.now());
            this.createAlert(alert);
        } else {
            alert.setUpdatedBy(userId);
            alert.setUpdatedAt(LocalDateTime.now());
            this.updateAlert(alert);
        }
    }
}

