/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.service.impl;

import com.github.pagehelper.PageHelper;
import com.zhyc.xps.aqpt.dto.AlertTypeDto;
import com.zhyc.xps.aqpt.entity.AlertType;
import com.zhyc.xps.aqpt.mapper.AlertTypeMapper;
import com.zhyc.xps.aqpt.service.AlertTypeService;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.service.BaseService;
import com.zhyc.xps.common.utils.IdGenerator.IdKit;
import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AlertTypeServiceImpl
extends BaseService
implements AlertTypeService {
    @Resource
    AlertTypeMapper alertTypeMapper;

    @Override
    public PageBean<AlertTypeDto> getAlertTypeByPage(Map<String, Object> map) {
        int page = Integer.parseInt("0" + map.get("page"));
        int limit = Integer.parseInt("0" + map.get("limit"));
        PageHelper.startPage((int)page, (int)limit);
        List<AlertTypeDto> list = this.alertTypeMapper.getByPage(map);
        return new PageBean(list);
    }

    @Override
    public AlertTypeDto getAlertTypeById(Long alertTypeId) {
        return this.alertTypeMapper.getById(alertTypeId);
    }

    @Override
    public List<AlertTypeDto> getAlertTypeByList(Map<String, Object> map) {
        return this.alertTypeMapper.getByList(map);
    }

    @Override
    public void createAlertType(AlertType alertType) throws Exception {
        alertType.setAlertTypeId(IdKit.getId());
        alertType.setCreatedAt(LocalDateTime.now());
        this.alertTypeMapper.create(alertType);
    }

    @Override
    public void updateAlertType(AlertType alertType) throws Exception {
        alertType.setUpdatedAt(LocalDateTime.now());
        this.alertTypeMapper.update(alertType);
    }

    @Override
    public void deleteAlertType(Map<String, Object> map) throws Exception {
        map.put("deletedFlag", 1);
        map.put("deletedAt", LocalDateTime.now());
        this.alertTypeMapper.delete(map);
    }
}

