/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.service.impl;

import com.github.pagehelper.PageHelper;
import com.zhyc.xps.aqpt.dto.CheckRecordAttachDto;
import com.zhyc.xps.aqpt.dto.CheckRecordDto;
import com.zhyc.xps.aqpt.entity.CheckRecord;
import com.zhyc.xps.aqpt.mapper.CheckRecordAttachMapper;
import com.zhyc.xps.aqpt.mapper.CheckRecordMapper;
import com.zhyc.xps.aqpt.service.CheckRecordService;
import com.zhyc.xps.aqpt.vo.CheckTaskDoingItemVo;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.service.BaseService;
import com.zhyc.xps.common.utils.IdGenerator.IdKit;
import com.zhyc.xps.sys.dto.GroupDto;
import com.zhyc.xps.sys.mapper.GroupMapper;
import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
@Transactional
public class CheckRecordServiceImpl
extends BaseService
implements CheckRecordService {
    @Resource
    CheckRecordMapper recordMapper;
    @Resource
    CheckRecordAttachMapper attachMapper;
    @Resource
    GroupMapper groupMapper;

    @Override
    public List<CheckRecordDto> getCheckRecordByList(Map<String, Object> map) {
        GroupDto group;
        long groupId;
        Long ocId = Long.valueOf("0" + map.get("ocId"));
        if (map.containsKey("groupId") && (groupId = Long.parseLong("0" + map.get("groupId"))) > 0L && !ObjectUtils.isEmpty((Object)(group = this.groupMapper.getById(ocId, Long.valueOf(groupId))))) {
            map.put("nodeLeft", group.getNodeLeft());
            map.put("nodeRight", group.getNodeRight());
        }
        return this.recordMapper.getByList(map);
    }

    @Override
    public void createCheckRecord(CheckRecord checkRecord) throws Exception {
        Long checkRecordId = IdKit.getId();
        checkRecord.setCheckRecordId(checkRecordId);
        checkRecord.setCheckTime(LocalDateTime.now());
        checkRecord.setCreatedAt(LocalDateTime.now());
        this.recordMapper.create(checkRecord);
    }

    @Override
    public PageBean<CheckRecordDto> getCheckRecordByPage(Map<String, Object> map) {
        GroupDto group;
        long groupId;
        Long ocId = Long.valueOf("0" + map.get("ocId"));
        if (map.containsKey("groupId") && (groupId = Long.parseLong("0" + map.get("groupId"))) > 0L && !ObjectUtils.isEmpty((Object)(group = this.groupMapper.getById(ocId, Long.valueOf(groupId))))) {
            map.put("nodeLeft", group.getNodeLeft());
            map.put("nodeRight", group.getNodeRight());
        }
        int page = Integer.parseInt("0" + map.get("page"));
        int limit = Integer.parseInt("0" + map.get("limit"));
        PageHelper.startPage((int)page, (int)limit);
        List<CheckRecordDto> list = this.recordMapper.getByPage(map);
        return new PageBean(list);
    }

    @Override
    public CheckTaskDoingItemVo getCheckRecordById(Long ocId, Long checkRecordId) {
        CheckRecordDto record = this.recordMapper.getById(ocId, checkRecordId);
        if (ObjectUtils.isEmpty((Object)record)) {
            return null;
        }
        CheckTaskDoingItemVo checkRecordVo = new CheckTaskDoingItemVo();
        checkRecordVo.setOcId(record.getOcId());
        checkRecordVo.setTaskId(record.getTaskId());
        checkRecordVo.setCheckRecordId(record.getCheckRecordId());
        checkRecordVo.setCheckResult(record.getCheckResult());
        checkRecordVo.setCheckDesc(record.getCheckDesc());
        checkRecordVo.setDangerId(record.getDangerId());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ocId", ocId);
        map.put("checkRecordId", checkRecordId);
        List<CheckRecordAttachDto> attachList = this.attachMapper.getByList(map);
        checkRecordVo.setAttachList(attachList);
        return checkRecordVo;
    }

    @Override
    public void deleteCheckRecordById(Long ocId, Long checkRecordId) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ocId", ocId);
        map.put("checkRecordId", checkRecordId);
        this.recordMapper.delete(map);
    }
}

