/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.service.impl;

import com.zhyc.xps.aqpt.dto.ChecklistHazardDto;
import com.zhyc.xps.aqpt.dto.ChecklistHazardRiskDto;
import com.zhyc.xps.aqpt.dto.ChecklistHazardRiskMeasureDto;
import com.zhyc.xps.aqpt.entity.ChecklistHazardRisk;
import com.zhyc.xps.aqpt.entity.ChecklistHazardRiskPosition;
import com.zhyc.xps.aqpt.mapper.ChecklistHazardMapper;
import com.zhyc.xps.aqpt.mapper.ChecklistHazardRiskMapper;
import com.zhyc.xps.aqpt.mapper.ChecklistHazardRiskMeasureMapper;
import com.zhyc.xps.aqpt.mapper.ChecklistHazardRiskPositionMapper;
import com.zhyc.xps.aqpt.service.ChecklistHazardRiskService;
import com.zhyc.xps.aqpt.vo.ChecklistHazardRiskVo;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.service.BaseService;
import com.zhyc.xps.common.utils.IdGenerator.IdKit;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ChecklistHazardRiskServiceImpl
extends BaseService
implements ChecklistHazardRiskService {
    @Autowired
    private ChecklistHazardMapper hazardMapper;
    @Autowired
    private ChecklistHazardRiskMapper riskMapper;
    @Autowired
    private ChecklistHazardRiskPositionMapper riskPositionMapper;
    @Autowired
    private ChecklistHazardRiskMeasureMapper measureMapper;

    @Override
    public ChecklistHazardRiskDto getRiskById(Long ocId, Long checklistId, Long hazardId, Long riskId) {
        return this.riskMapper.getById(ocId, checklistId, hazardId, riskId);
    }

    @Override
    public PageBean<ChecklistHazardRiskVo> getRiskByPage(Map<String, Object> map) {
        Long ocId = Long.valueOf("0" + map.get("ocId"));
        Long checklistId = Long.valueOf("0" + map.get("checklistId"));
        Long rootHazardId = Long.valueOf("0" + map.get("hazardId"));
        Long nodeLeft = 0L;
        Long nodeRight = 0L;
        ChecklistHazardDto hazardDto = this.hazardMapper.getById(ocId, checklistId, rootHazardId);
        if (hazardDto != null) {
            nodeLeft = hazardDto.getNodeLeft();
            nodeRight = hazardDto.getNodeRight();
        }
        map.put("nodeLeft", nodeLeft);
        map.put("nodeRight", nodeRight);
        map.remove("hazardId");
        List<ChecklistHazardRiskDto> riskDtoList = this.riskMapper.getByPage(map);
        ArrayList<ChecklistHazardRiskVo> riskVoList = new ArrayList<ChecklistHazardRiskVo>();
        for (ChecklistHazardRiskDto riskDto : riskDtoList) {
            ChecklistHazardRiskVo riskVo = new ChecklistHazardRiskVo();
            Long hazardId = riskDto.getHazardId();
            Long riskId = riskDto.getRiskId();
            riskVo.setChecklistId(checklistId);
            riskVo.setHazardId(hazardId);
            riskVo.setHazardTitle(riskDto.getHazardTitle());
            riskVo.setRiskId(riskId);
            riskVo.setRiskCode(riskDto.getRiskCode());
            riskVo.setRiskSource(riskDto.getRiskSource());
            riskVo.setRiskReason(riskDto.getRiskReason());
            riskVo.setRiskConsequence(riskDto.getRiskConsequence());
            riskVo.setRiskTypeId(riskDto.getRiskTypeId());
            riskVo.setRiskLevel(riskDto.getRiskLevel());
            riskVo.setCtrlLevelId(riskDto.getCtrlLevelId());
            riskVo.setCtrlLevelTitle(riskDto.getCtrlLevelTitle());
            riskVo.setPositionNameList(riskDto.getPositionNameList());
            riskVoList.add(riskVo);
            HashMap<String, Object> map2 = new HashMap<String, Object>();
            map2.put("ocId", ocId);
            map2.put("checklistId", checklistId);
            map2.put("hazardId", hazardId);
            map2.put("riskId", riskId);
            List<ChecklistHazardRiskMeasureDto> measureDtoList = this.measureMapper.getByList(map2);
            riskVo.setMeasureList(measureDtoList);
        }
        PageBean pageData = new PageBean(riskVoList);
        return pageData;
    }

    @Override
    public List<ChecklistHazardRiskVo> getRiskByList(Map<String, Object> map) {
        Long ocId = Long.valueOf("0" + map.get("ocId"));
        Long checklistId = Long.valueOf("0" + map.get("checklistId"));
        Long rootHazardId = Long.valueOf("0" + map.get("hazardId"));
        Long nodeLeft = 0L;
        Long nodeRight = 0L;
        ChecklistHazardDto hazardDto = this.hazardMapper.getById(ocId, checklistId, rootHazardId);
        if (hazardDto != null) {
            nodeLeft = hazardDto.getNodeLeft();
            nodeRight = hazardDto.getNodeRight();
        }
        map.put("nodeLeft", nodeLeft);
        map.put("nodeRight", nodeRight);
        map.remove("hazardId");
        List<ChecklistHazardRiskDto> riskDtoList = this.riskMapper.getByList(map);
        ArrayList<ChecklistHazardRiskVo> riskVoList = new ArrayList<ChecklistHazardRiskVo>();
        for (ChecklistHazardRiskDto riskDto : riskDtoList) {
            ChecklistHazardRiskVo riskVo = new ChecklistHazardRiskVo();
            Long hazardId = riskDto.getHazardId();
            Long riskId = riskDto.getRiskId();
            riskVo.setChecklistId(checklistId);
            riskVo.setHazardId(hazardId);
            riskVo.setHazardTitle(riskDto.getHazardTitle());
            riskVo.setRiskId(riskId);
            riskVo.setRiskCode(riskDto.getRiskCode());
            riskVo.setRiskSource(riskDto.getRiskSource());
            riskVo.setRiskReason(riskDto.getRiskReason());
            riskVo.setRiskConsequence(riskDto.getRiskConsequence());
            riskVo.setRiskTypeId(riskDto.getRiskTypeId());
            riskVo.setRiskLevel(riskDto.getRiskLevel());
            riskVo.setCtrlLevelId(riskDto.getCtrlLevelId());
            riskVo.setCtrlLevelTitle(riskDto.getCtrlLevelTitle());
            riskVo.setPositionNameList(riskDto.getPositionNameList());
            riskVoList.add(riskVo);
            HashMap<String, Object> map2 = new HashMap<String, Object>();
            map2.put("ocId", ocId);
            map2.put("checklistId", checklistId);
            map2.put("hazardId", hazardId);
            map2.put("riskId", riskId);
            List<ChecklistHazardRiskMeasureDto> measureDtoList = this.measureMapper.getByList(map2);
            riskVo.setMeasureList(measureDtoList);
        }
        return riskVoList;
    }

    @Override
    public List<ChecklistHazardRiskVo> getRiskByHazard(Long ocId, Long checklistId, Long hazardId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ocId", ocId);
        map.put("checklistId", checklistId);
        map.put("hazardId", hazardId);
        List<ChecklistHazardRiskDto> riskDtoList = this.riskMapper.getByList(map);
        ArrayList<ChecklistHazardRiskVo> riskVoList = new ArrayList<ChecklistHazardRiskVo>();
        for (ChecklistHazardRiskDto riskDto : riskDtoList) {
            ChecklistHazardRiskVo riskVo = new ChecklistHazardRiskVo();
            Long tHazardId = riskDto.getHazardId();
            Long riskId = riskDto.getRiskId();
            riskVo.setChecklistId(checklistId);
            riskVo.setHazardId(tHazardId);
            riskVo.setRiskId(riskId);
            riskVo.setRiskCode(riskDto.getRiskCode());
            riskVo.setRiskSource(riskDto.getRiskSource());
            riskVo.setRiskReason(riskDto.getRiskReason());
            riskVo.setRiskConsequence(riskDto.getRiskConsequence());
            riskVo.setRiskTypeId(riskDto.getRiskTypeId());
            riskVo.setRiskLevel(riskDto.getRiskLevel());
            riskVo.setCtrlLevelId(riskDto.getCtrlLevelId());
            riskVo.setCtrlLevelTitle(riskDto.getCtrlLevelTitle());
            riskVo.setPositionNameList(riskDto.getPositionNameList());
            riskVoList.add(riskVo);
            HashMap<String, Object> map2 = new HashMap<String, Object>();
            map2.put("ocId", ocId);
            map2.put("checklistId", checklistId);
            map2.put("hazardId", tHazardId);
            map2.put("riskId", riskId);
            List<ChecklistHazardRiskMeasureDto> measureDtoList = this.measureMapper.getByList(map2);
            riskVo.setMeasureList(measureDtoList);
        }
        return riskVoList;
    }

    @Override
    public void createRisk(ChecklistHazardRiskDto riskDto) throws Exception {
        String[] positionIdStrArray;
        Long ocId = riskDto.getOcId();
        Long checklistId = riskDto.getChecklistId();
        Long hazardId = riskDto.getHazardId();
        Long riskId = IdKit.getId();
        Long createdBy = riskDto.getCreatedBy();
        ChecklistHazardRisk risk = new ChecklistHazardRisk();
        risk.setOcId(ocId);
        risk.setChecklistId(checklistId);
        risk.setHazardId(hazardId);
        risk.setRiskId(riskId);
        risk.setRiskCode(riskDto.getRiskCode());
        risk.setRiskSource(riskDto.getRiskSource());
        risk.setRiskReason(riskDto.getRiskReason());
        risk.setRiskConsequence(riskDto.getRiskConsequence());
        risk.setRiskTypeId(riskDto.getRiskTypeId());
        risk.setRiskLevel(riskDto.getRiskLevel());
        risk.setCtrlLevelId(riskDto.getCtrlLevelId());
        risk.setCreatedBy(createdBy);
        risk.setCreatedAt(LocalDateTime.now());
        this.riskMapper.create(risk);
        String positionIdList = riskDto.getPositionIdList();
        for (String szPositionId : positionIdStrArray = positionIdList.split(",")) {
            ChecklistHazardRiskPosition position = new ChecklistHazardRiskPosition();
            position.setOcId(ocId);
            position.setChecklistId(checklistId);
            position.setHazardId(hazardId);
            position.setRiskId(riskId);
            position.setPositionId(Long.valueOf(szPositionId));
            position.setCreatedAt(LocalDateTime.now());
            position.setCreatedBy(createdBy);
            this.riskPositionMapper.create(position);
        }
    }

    @Override
    public void updateRisk(ChecklistHazardRiskDto riskDto) throws Exception {
        String[] positionIdStrArray;
        Long ocId = riskDto.getOcId();
        Long checklistId = riskDto.getChecklistId();
        Long hazardId = riskDto.getHazardId();
        Long riskId = riskDto.getRiskId();
        Long createdBy = riskDto.getCreatedBy();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ocId", ocId);
        map.put("checklistId", checklistId);
        map.put("hazardId", hazardId);
        map.put("riskId", riskId);
        this.riskPositionMapper.delete(map);
        ChecklistHazardRisk risk = new ChecklistHazardRisk();
        risk.setOcId(ocId);
        risk.setChecklistId(checklistId);
        risk.setHazardId(hazardId);
        risk.setRiskId(riskId);
        risk.setRiskCode(riskDto.getRiskCode());
        risk.setRiskSource(riskDto.getRiskSource());
        risk.setRiskReason(riskDto.getRiskReason());
        risk.setRiskConsequence(riskDto.getRiskConsequence());
        risk.setRiskTypeId(riskDto.getRiskTypeId());
        risk.setRiskLevel(riskDto.getRiskLevel());
        risk.setCtrlLevelId(riskDto.getCtrlLevelId());
        risk.setCreatedBy(createdBy);
        risk.setCreatedAt(LocalDateTime.now());
        this.riskMapper.update(risk);
        String positionIdList = riskDto.getPositionIdList();
        for (String szPositionId : positionIdStrArray = positionIdList.split(",")) {
            ChecklistHazardRiskPosition position = new ChecklistHazardRiskPosition();
            position.setOcId(ocId);
            position.setChecklistId(checklistId);
            position.setHazardId(hazardId);
            position.setRiskId(riskId);
            position.setPositionId(Long.valueOf(szPositionId));
            position.setCreatedAt(LocalDateTime.now());
            position.setCreatedBy(createdBy);
            this.riskPositionMapper.create(position);
        }
    }

    @Override
    public void updateRiskLevel(Long ocId, Long checklistId, Long hazardId, Long riskId, Long riskLevel) throws Exception {
        ChecklistHazardRisk risk = new ChecklistHazardRisk();
        risk.setOcId(ocId);
        risk.setChecklistId(checklistId);
        risk.setHazardId(hazardId);
        risk.setRiskId(riskId);
        risk.setRiskLevel(riskLevel);
        risk.setUpdatedAt(LocalDateTime.now());
        this.riskMapper.update(risk);
    }

    @Override
    public void deleteRisk(Map<String, Object> map) throws Exception {
        map.put("deletedFlag", 1L);
        map.put("deletedAt", LocalDateTime.now());
        this.riskMapper.delete(map);
    }

    @Override
    public void deleteRiskById(Long ocId, Long checklistId, Long hazardId, Long riskId) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ocId", ocId);
        map.put("checklistId", checklistId);
        map.put("hazardId", hazardId);
        map.put("riskId", riskId);
        map.put("deletedFlag", 1L);
        map.put("deletedAt", LocalDateTime.now());
        this.riskMapper.delete(map);
    }
}

