/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.service.impl;

import com.github.pagehelper.PageHelper;
import com.zhyc.xps.aqpt.entity.EntCtrlLevel;
import com.zhyc.xps.aqpt.mapper.EntCtrlLevelMapper;
import com.zhyc.xps.aqpt.service.EntCtrlLevelService;
import com.zhyc.xps.common.entity.Checklist;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.mapper.ChecklistMapper;
import com.zhyc.xps.common.service.BaseService;
import com.zhyc.xps.common.utils.IdGenerator.IdKit;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class EntCtrlLevelServiceImpl
extends BaseService
implements EntCtrlLevelService {
    @Autowired
    private EntCtrlLevelMapper ctrlLevelMapper;
    @Autowired
    private ChecklistMapper checklistMapper;

    @Override
    public EntCtrlLevel getCtrlLevelById(Long ocId, Long ctrlLevelId) {
        return this.ctrlLevelMapper.getById(ocId, ctrlLevelId);
    }

    @Override
    public List<EntCtrlLevel> getCtrlLevelList(Map<String, Object> map) {
        return this.ctrlLevelMapper.getByList(map);
    }

    @Override
    public PageBean<EntCtrlLevel> getCtrlLevelByPage(Map<String, Object> map) {
        int page = Integer.valueOf("0" + map.get("page"));
        int limit = Integer.valueOf("0" + map.get("limit"));
        PageHelper.startPage((int)page, (int)limit);
        List<EntCtrlLevel> list = this.ctrlLevelMapper.getByPage(map);
        PageBean pageData = new PageBean(list);
        return pageData;
    }

    @Override
    public List<EntCtrlLevel> getEnabledCtrlLevelList(Map<String, Object> map) {
        map.put("isEnabled", 1);
        return this.ctrlLevelMapper.getByList(map);
    }

    @Override
    public void createCtrlLevel(EntCtrlLevel ctrlLevel) throws Exception {
        ctrlLevel.setCtrlLevelId(IdKit.getId());
        ctrlLevel.setCreatedAt(LocalDateTime.now());
        this.ctrlLevelMapper.create(ctrlLevel);
    }

    @Override
    public void updateCtrlLevel(EntCtrlLevel ctrlLevel) throws Exception {
        ctrlLevel.setUpdatedAt(LocalDateTime.now());
        this.ctrlLevelMapper.update(ctrlLevel);
        Long ocId = ctrlLevel.getOcId();
        Long checkListId = ctrlLevel.getCtrlLevelId();
        String checkListTitle = ctrlLevel.getCtrlLevelTitle();
        Checklist checklist = new Checklist();
        checklist.setChecklistId(checkListId);
        checklist.setChecklistTitle(checkListTitle + "\u6e05\u5355");
        this.checklistMapper.update(checklist);
    }

    @Override
    public void enableCtrlLevel(Long ocId, Long ctrlLevelId, Long bEnabled) throws Exception {
        EntCtrlLevel ctrlLevel = new EntCtrlLevel();
        ctrlLevel.setOcId(ocId);
        ctrlLevel.setCtrlLevelId(ctrlLevelId);
        ctrlLevel.setIsEnabled(bEnabled);
        this.ctrlLevelMapper.update(ctrlLevel);
    }

    @Override
    public void deleteCtrlLevel(Map<String, Object> map) throws Exception {
        map.put("deletedFlag", 1);
        map.put("deletedAt", LocalDateTime.now());
        this.ctrlLevelMapper.delete(map);
    }

    @Override
    public void deleteCtrlLevelById(Long ocId, Long ctrlLevelId) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ocId", ocId);
        map.put("ctrlLevelId", ctrlLevelId);
        map.put("deletedFlag", 1);
        map.put("deletedAt", LocalDateTime.now());
        this.ctrlLevelMapper.delete(map);
    }
}

