/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.service.impl;

import com.github.pagehelper.PageHelper;
import com.zhyc.xps.aqpt.dto.EntRiskPointArtDto;
import com.zhyc.xps.aqpt.entity.EntRiskPointArt;
import com.zhyc.xps.aqpt.mapper.EntRiskPointArtMapper;
import com.zhyc.xps.aqpt.service.EntRiskPointArtService;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.service.BaseService;
import com.zhyc.xps.sys.constant.Glob;
import com.zhyc.xps.sys.dto.ArtCatDto;
import com.zhyc.xps.sys.dto.ArtDto;
import com.zhyc.xps.sys.mapper.ArtCatMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class EntRiskPointArtServiceImpl
extends BaseService
implements EntRiskPointArtService {
    @Autowired
    private EntRiskPointArtMapper riskPointArtMapper;
    @Autowired
    private ArtCatMapper artCatMapper;

    @Override
    public PageBean<EntRiskPointArtDto> getRiskPointArtByPage(Map<String, Object> map) {
        int page = Integer.valueOf("0" + map.get("page"));
        int limit = Integer.valueOf("0" + map.get("limit"));
        PageHelper.startPage((int)page, (int)limit);
        List<EntRiskPointArtDto> list = this.riskPointArtMapper.getByPage(map);
        PageBean pageData = new PageBean(list);
        return pageData;
    }

    @Override
    public List<EntRiskPointArtDto> getRiskPointArtByList(Long ocId, Long riskPointId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ocId", ocId);
        map.put("riskPointId", riskPointId);
        return this.riskPointArtMapper.getByList(map);
    }

    @Override
    public void createRiskPointArt(EntRiskPointArt riskPointArt) throws Exception {
        this.riskPointArtMapper.create(riskPointArt);
    }

    @Override
    public void deleteRiskPointArt(Long ocId, Long riskPointId, Long artId) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ocId", ocId);
        map.put("riskPointId", riskPointId);
        map.put("artId", artId);
        this.riskPointArtMapper.delete(map);
    }

    @Override
    public PageBean<ArtDto> getArtSelectByPage(Map<String, Object> map) {
        int page = Integer.valueOf("0" + map.get("page"));
        int limit = Integer.valueOf("0" + map.get("limit"));
        Long ocId = Long.valueOf("0" + map.get("ocId"));
        ArtCatDto artCat = this.artCatMapper.getById(ocId, Glob.ART_CAT_INSTRUCTION);
        if (artCat != null) {
            Long nodeLeft = artCat.getNodeLeft();
            Long nodeRight = artCat.getNodeRight();
            map.put("nodeLeft", nodeLeft);
            map.put("nodeRight", nodeRight);
            map.put("status", Glob.ART_STATUS_ISSUED);
        }
        PageHelper.startPage((int)page, (int)limit);
        List<ArtDto> list = this.riskPointArtMapper.getSelectByPage(map);
        PageBean pageData = new PageBean(list);
        return pageData;
    }
}

