/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.service.impl;

import com.github.pagehelper.PageHelper;
import com.zhyc.xps.aqpt.dto.ChecklistHazardDto;
import com.zhyc.xps.aqpt.dto.ChecklistHazardRiskDto;
import com.zhyc.xps.aqpt.dto.ChecklistHazardRiskMeasureDto;
import com.zhyc.xps.aqpt.dto.EntRiskPointHazardDto;
import com.zhyc.xps.aqpt.entity.EntRiskPointHazard;
import com.zhyc.xps.aqpt.mapper.ChecklistHazardRiskMapper;
import com.zhyc.xps.aqpt.mapper.ChecklistHazardRiskMeasureMapper;
import com.zhyc.xps.aqpt.mapper.EntRiskPointHazardMapper;
import com.zhyc.xps.aqpt.service.EntRiskPointHazardService;
import com.zhyc.xps.aqpt.vo.ChecklistHazardRiskVo;
import com.zhyc.xps.aqpt.vo.ChecklistHazardVo;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.service.BaseService;
import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class EntRiskPointHazardServiceImpl
extends BaseService
implements EntRiskPointHazardService {
    @Resource
    EntRiskPointHazardMapper riskPointHazardMapper;
    @Resource
    ChecklistHazardRiskMapper riskMapper;
    @Resource
    ChecklistHazardRiskMeasureMapper measureMapper;

    @Override
    public PageBean<EntRiskPointHazardDto> getRiskPointHazardByPage(Map<String, Object> map) {
        int page = Integer.parseInt("0" + map.get("page"));
        int limit = Integer.parseInt("0" + map.get("limit"));
        PageHelper.startPage((int)page, (int)limit);
        List<EntRiskPointHazardDto> list = this.riskPointHazardMapper.getByPage(map);
        return new PageBean(list);
    }

    @Override
    public List<EntRiskPointHazardDto> getRiskPointHazardByList(Map<String, Object> map) {
        return this.riskPointHazardMapper.getByList(map);
    }

    @Override
    public List<ChecklistHazardDto> getSelectHazardByList(Map<String, Object> map) {
        return this.riskPointHazardMapper.getSelectByList(map);
    }

    @Override
    public List<ChecklistHazardVo> getRiskPointHazardViewByList(Map<String, Object> map) {
        List<EntRiskPointHazardDto> hazardList = this.riskPointHazardMapper.getByList(map);
        List<ChecklistHazardRiskDto> riskList = this.riskMapper.getByList(map);
        List<ChecklistHazardRiskMeasureDto> measureList = this.measureMapper.getByList(map);
        ArrayList<ChecklistHazardVo> hazardVoList = new ArrayList<ChecklistHazardVo>();
        for (EntRiskPointHazardDto hazardDto : hazardList) {
            Long hazardId = hazardDto.getHazardId();
            ChecklistHazardVo hazardVo = new ChecklistHazardVo();
            hazardVo.setHazardId(hazardId);
            hazardVo.setHazardCode(hazardDto.getHazardCode());
            hazardVo.setHazardTitle(hazardDto.getHazardTitle());
            hazardVo.setHazardDesc(hazardDto.getHazardDesc());
            hazardVo.setHazardLevel(hazardDto.getHazardLevel());
            hazardVo.setHazardImage(hazardDto.getHazardImage());
            hazardVo.setHazardTypeId(hazardDto.getHazardTypeId());
            hazardVo.setHazardTypeTitle(hazardDto.getHazardTypeTitle());
            ArrayList<ChecklistHazardRiskVo> riskVoList = new ArrayList<ChecklistHazardRiskVo>();
            for (ChecklistHazardRiskDto risk : riskList) {
                if (risk.getHazardId().longValue() != hazardId.longValue()) continue;
                Long riskId = risk.getRiskId();
                ChecklistHazardRiskVo riskVo = new ChecklistHazardRiskVo();
                riskVo.setRiskId(riskId);
                riskVo.setRiskCode(risk.getRiskCode());
                riskVo.setRiskSource(risk.getRiskSource());
                riskVo.setRiskReason(risk.getRiskReason());
                riskVo.setRiskConsequence(risk.getRiskConsequence());
                riskVo.setRiskTypeId(risk.getRiskTypeId());
                riskVo.setRiskLevel(risk.getRiskLevel());
                ArrayList<ChecklistHazardRiskMeasureDto> measureVoList = new ArrayList<ChecklistHazardRiskMeasureDto>();
                for (ChecklistHazardRiskMeasureDto measure : measureList) {
                    Long mHazardId = measure.getHazardId();
                    Long mRiskId = measure.getRiskId();
                    if (mHazardId.longValue() != hazardId.longValue() || mRiskId.longValue() != riskId.longValue()) continue;
                    measureVoList.add(measure);
                }
                riskVo.setMeasureList(measureVoList);
                riskVoList.add(riskVo);
            }
            hazardVo.setRiskList(riskVoList);
            hazardVoList.add(hazardVo);
        }
        return hazardVoList;
    }

    @Override
    public void createRiskPointHazard(EntRiskPointHazard riskPointHazard) throws Exception {
        riskPointHazard.setStatus(1L);
        riskPointHazard.setCreatedAt(LocalDateTime.now());
        this.riskPointHazardMapper.create(riskPointHazard);
    }

    @Override
    public void deleteRiskPointHazardById(Long ocId, Long riskPointId, Long checklistId, Long hazardId) throws Exception {
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("ocId", ocId);
        map1.put("riskPointId", riskPointId);
        map1.put("checklistId", checklistId);
        map1.put("hazardId", hazardId);
        this.riskPointHazardMapper.delete(map1);
    }
}

