/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.service.impl;

import com.zhyc.xps.aqpt.constant.Glob;
import com.zhyc.xps.aqpt.dto.EntRiskPointMapLayerDto;
import com.zhyc.xps.aqpt.entity.EntRiskPointMapLayer;
import com.zhyc.xps.aqpt.mapper.EntRiskPointMapLayerMapper;
import com.zhyc.xps.aqpt.service.EntRiskPointMapLayerService;
import com.zhyc.xps.common.service.BaseService;
import com.zhyc.xps.common.utils.IdGenerator.IdKit;
import com.zhyc.xps.sys.entity.EntMapLayer;
import com.zhyc.xps.sys.mapper.EntMapLayerMapper;
import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class EntRiskPointMapLayerServiceImpl
extends BaseService
implements EntRiskPointMapLayerService {
    @Resource
    EntRiskPointMapLayerMapper riskPointMapLayerMapper;
    @Resource
    EntMapLayerMapper mapLayerMapper;

    @Override
    public EntRiskPointMapLayerDto getRiskPointMapLayerById(Long ocId, Long riskPointId) {
        return this.riskPointMapLayerMapper.getById(ocId, riskPointId);
    }

    @Override
    public void createRiskPointMapLayer(EntRiskPointMapLayerDto riskPointMapLayerDto) throws Exception {
        Long ocId = riskPointMapLayerDto.getOcId();
        Long riskPointId = riskPointMapLayerDto.getRiskPointId();
        Long mapId = riskPointMapLayerDto.getMapId();
        Long layerId = IdKit.getId();
        EntMapLayer mapLayer = new EntMapLayer();
        mapLayer.setOcId(ocId);
        mapLayer.setMapId(mapId);
        mapLayer.setLayerId(layerId);
        mapLayer.setLayerCatId(Glob.MAP_LAYER_CAT_RISKPOINT);
        mapLayer.setLayerTitle(riskPointMapLayerDto.getLayerTitle());
        mapLayer.setLayerMarker(riskPointMapLayerDto.getLayerMarker());
        mapLayer.setLayerVector(riskPointMapLayerDto.getLayerVector());
        mapLayer.setLayerVectorType(riskPointMapLayerDto.getLayerVectorType());
        mapLayer.setCreatedAt(LocalDateTime.now());
        this.mapLayerMapper.create(mapLayer);
        EntRiskPointMapLayer riskPointMapLayer = new EntRiskPointMapLayer();
        riskPointMapLayer.setOcId(ocId);
        riskPointMapLayer.setRiskPointId(riskPointId);
        riskPointMapLayer.setMapId(mapId);
        riskPointMapLayer.setLayerId(layerId);
        riskPointMapLayer.setCreatedAt(LocalDateTime.now());
        this.riskPointMapLayerMapper.create(riskPointMapLayer);
    }

    @Override
    public void updateRiskPointMapLayer(EntRiskPointMapLayerDto riskPointMapLayerDto) throws Exception {
        Long ocId = riskPointMapLayerDto.getOcId();
        Long mapId = riskPointMapLayerDto.getMapId();
        Long layerId = riskPointMapLayerDto.getLayerId();
        EntMapLayer mapLayer = new EntMapLayer();
        mapLayer.setOcId(ocId);
        mapLayer.setMapId(mapId);
        mapLayer.setLayerId(layerId);
        mapLayer.setLayerTitle(riskPointMapLayerDto.getLayerTitle());
        mapLayer.setLayerMarker(riskPointMapLayerDto.getLayerMarker());
        mapLayer.setLayerVector(riskPointMapLayerDto.getLayerVector());
        mapLayer.setLayerVectorType(riskPointMapLayerDto.getLayerVectorType());
        mapLayer.setUpdatedAt(LocalDateTime.now());
        this.mapLayerMapper.update(mapLayer);
    }

    @Override
    public void deleteRiskPointMapLayer(Map<String, Object> map) throws Exception {
        this.riskPointMapLayerMapper.delete(map);
    }

    @Override
    public void deleteRiskPointMapLayerById(Long ocId, Long riskPointId, Long mapId, Long layerId) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ocId", ocId);
        map.put("riskPointId", riskPointId);
        map.put("mapId", mapId);
        map.put("layerId", layerId);
        this.riskPointMapLayerMapper.delete(map);
        this.mapLayerMapper.delete(map);
    }
}

