/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.service.impl;

import com.github.pagehelper.PageHelper;
import com.zhyc.xps.aqpt.dto.EquipmentCatDto;
import com.zhyc.xps.aqpt.entity.EquipmentCat;
import com.zhyc.xps.aqpt.mapper.EquipmentCatMapper;
import com.zhyc.xps.aqpt.service.EquipmentCatService;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.service.BaseService;
import com.zhyc.xps.common.utils.IdGenerator.IdKit;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class EquipmentCatServiceImpl
extends BaseService
implements EquipmentCatService {
    @Autowired
    private EquipmentCatMapper equipmentCatMapper;

    @Override
    public EquipmentCatDto getEquipmentCatById(Long ocId, Long equipCatId) {
        return this.equipmentCatMapper.getById(ocId, equipCatId);
    }

    @Override
    public List<EquipmentCatDto> getEquipmentCatByList(Map<String, Object> map) {
        return this.equipmentCatMapper.getByList(map);
    }

    @Override
    public PageBean<EquipmentCatDto> getEquipmentCatByPage(Map<String, Object> map) {
        int page = Integer.parseInt("0" + map.get("page"));
        int limit = Integer.parseInt("0" + map.get("limit"));
        PageHelper.startPage((int)page, (int)limit);
        List<EquipmentCatDto> list = this.equipmentCatMapper.getByPage(map);
        return new PageBean(list);
    }

    @Override
    public void createEquipmentCat(EquipmentCat equipmentCat) throws Exception {
        equipmentCat.setEquipCatId(IdKit.getId());
        equipmentCat.setCreatedAt(LocalDateTime.now());
        this.equipmentCatMapper.create(equipmentCat);
    }

    @Override
    public void updateEquipmentCat(EquipmentCat equipmentCat) throws Exception {
        equipmentCat.setUpdatedAt(LocalDateTime.now());
        this.equipmentCatMapper.update(equipmentCat);
    }

    @Override
    public void deleteEquipmentCat(Map<String, Object> map) throws Exception {
        map.put("deletedFlag", 1);
        map.put("deletedAt", LocalDateTime.now());
        this.equipmentCatMapper.delete(map);
    }
}

