/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.service.impl;

import com.zhyc.xps.aqpt.dto.ChecklistHazardDto;
import com.zhyc.xps.aqpt.dto.ChecklistHazardRiskDto;
import com.zhyc.xps.aqpt.dto.ChecklistHazardRiskMeasureDto;
import com.zhyc.xps.aqpt.mapper.ChecklistHazardMapper;
import com.zhyc.xps.aqpt.mapper.ChecklistHazardRiskMapper;
import com.zhyc.xps.aqpt.mapper.ChecklistHazardRiskMeasureMapper;
import com.zhyc.xps.aqpt.service.HazardChecklistService;
import com.zhyc.xps.aqpt.vo.ChecklistHazardRiskVo;
import com.zhyc.xps.aqpt.vo.ChecklistHazardVo;
import com.zhyc.xps.aqpt.vo.HazardChecklistVo;
import com.zhyc.xps.common.dto.ChecklistDto;
import com.zhyc.xps.common.mapper.ChecklistMapper;
import com.zhyc.xps.common.service.BaseService;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class HazardChecklistServiceImpl
extends BaseService
implements HazardChecklistService {
    @Resource
    private ChecklistMapper checklistMapper;
    @Resource
    private ChecklistHazardMapper hazardMapper;
    @Resource
    private ChecklistHazardRiskMapper riskMapper;
    @Resource
    private ChecklistHazardRiskMeasureMapper measureMapper;

    @Override
    public HazardChecklistVo getChecklistViewById(Long ocId, Long checklistId) {
        ChecklistDto checklist = this.checklistMapper.getById(ocId, checklistId);
        if (checklist == null) {
            return null;
        }
        Long checklistTypeId = checklist.getChecklistTypeId();
        HazardChecklistVo hazardChecklistVo = new HazardChecklistVo();
        hazardChecklistVo.setChecklistId(checklistId);
        hazardChecklistVo.setChecklistTitle(checklist.getChecklistTitle());
        hazardChecklistVo.setChecklistTypeId(checklistTypeId);
        hazardChecklistVo.setChecklistCatId(checklist.getChecklistCatId());
        hazardChecklistVo.setChecklistCatTitle(checklist.getChecklistCatTitle());
        hazardChecklistVo.setChecklistDesc(checklist.getChecklistDesc());
        hazardChecklistVo.setAuthor(checklist.getAuthor());
        hazardChecklistVo.setVersion(checklist.getVersion());
        hazardChecklistVo.setIsFixed(checklist.getIsFixed());
        hazardChecklistVo.setIssuedAccountId(checklist.getIssuedAccountId());
        hazardChecklistVo.setIssuedAccountName(checklist.getIssuedAccountName());
        hazardChecklistVo.setIssuedAt(checklist.getIssuedAt());
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("ocId", ocId);
        if (checklistTypeId == 1L) {
            map1.put("ctrlLevelId", checklistId);
            map1.put("checklistId", ocId);
        } else {
            map1.put("checklistId", checklistId);
        }
        List<ChecklistHazardDto> hazardList = this.hazardMapper.getByList(map1);
        List<ChecklistHazardRiskDto> riskList = this.riskMapper.getByList(map1);
        List<ChecklistHazardRiskMeasureDto> measureList = this.measureMapper.getByList(map1);
        ArrayList<ChecklistHazardVo> hazardVoList = new ArrayList<ChecklistHazardVo>();
        for (ChecklistHazardDto hazardDto : hazardList) {
            Long hazardId = hazardDto.getHazardId();
            ChecklistHazardVo hazardVo = new ChecklistHazardVo();
            hazardVo.setHazardId(hazardId);
            hazardVo.setHazardCode(hazardDto.getHazardCode());
            hazardVo.setHazardTitle(hazardDto.getHazardTitle());
            hazardVo.setHazardDesc(hazardDto.getHazardDesc());
            hazardVo.setHazardLevel(hazardDto.getHazardLevel());
            hazardVo.setHazardImage(hazardDto.getHazardImage());
            hazardVo.setHazardTypeId(hazardDto.getHazardTypeId());
            hazardVo.setHazardTypeTitle(hazardDto.getHazardTypeTitle());
            ArrayList<ChecklistHazardRiskVo> riskVoList = new ArrayList<ChecklistHazardRiskVo>();
            for (ChecklistHazardRiskDto risk : riskList) {
                if (risk.getHazardId().longValue() != hazardId.longValue()) continue;
                Long riskId = risk.getRiskId();
                ChecklistHazardRiskVo riskVo = new ChecklistHazardRiskVo();
                riskVo.setRiskId(riskId);
                riskVo.setRiskCode(risk.getRiskCode());
                riskVo.setRiskSource(risk.getRiskSource());
                riskVo.setRiskReason(risk.getRiskReason());
                riskVo.setRiskConsequence(risk.getRiskConsequence());
                riskVo.setRiskTypeId(risk.getRiskTypeId());
                riskVo.setRiskLevel(risk.getRiskLevel());
                ArrayList<ChecklistHazardRiskMeasureDto> measureVoList = new ArrayList<ChecklistHazardRiskMeasureDto>();
                for (ChecklistHazardRiskMeasureDto measure : measureList) {
                    Long mHazardId = measure.getHazardId();
                    Long mRiskId = measure.getRiskId();
                    if (mHazardId.longValue() != hazardId.longValue() || mRiskId.longValue() != riskId.longValue()) continue;
                    measureVoList.add(measure);
                }
                riskVo.setMeasureList(measureVoList);
                riskVoList.add(riskVo);
            }
            hazardVo.setRiskList(riskVoList);
            hazardVoList.add(hazardVo);
        }
        hazardChecklistVo.setHazardList(hazardVoList);
        return hazardChecklistVo;
    }
}

