/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.service.impl;

import com.zhyc.xps.aqpt.dto.AlertDto;
import com.zhyc.xps.aqpt.dto.EntDangerDto;
import com.zhyc.xps.aqpt.mapper.AlertMapper;
import com.zhyc.xps.aqpt.mapper.EntDangerMapper;
import com.zhyc.xps.aqpt.mapper.EntDangerStatisMapper;
import com.zhyc.xps.aqpt.mapper.EntRiskPointMapper;
import com.zhyc.xps.aqpt.service.PanoramaService;
import com.zhyc.xps.common.service.BaseService;
import com.zhyc.xps.sys.mapper.EntMapLayerMapper;
import com.zhyc.xps.sys.mapper.TaskMapper;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PanoramaServiceImpl
extends BaseService
implements PanoramaService {
    @Resource
    EntRiskPointMapper riskPointMapper;
    @Resource
    TaskMapper taskMapper;
    @Resource
    EntMapLayerMapper mapLayerMapper;
    @Resource
    EntDangerMapper dangerMapper;
    @Resource
    EntDangerStatisMapper dangerStatisMapper;
    @Resource
    ThreadPoolExecutor executor;
    @Resource
    AlertMapper alertMapper;

    @Override
    public Map<String, Object> getPanorama(Long ocId) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        HashMap<String, Long> map1 = new HashMap<String, Long>(16);
        map1.put("ocId", ocId);
        CompletableFuture<Void> riskPointCounter = CompletableFuture.runAsync(() -> result.put("riskPointCounter", 0), this.executor);
        CompletableFuture<Void> todayTask = CompletableFuture.runAsync(() -> {
            HashMap<String, Number> map2 = new HashMap<String, Number>(16);
            map2.put("ocId", ocId);
            map2.put("isWaiting", 1);
            map2.put("now", 1);
            List taskList = this.taskMapper.getByList(map2);
            result.put("todayTaskList", taskList);
            result.put("todayTaskTotal", taskList.size());
        }, this.executor);
        CompletableFuture<Void> mapLayerList = CompletableFuture.runAsync(() -> {
            List layerList = this.mapLayerMapper.getByList(map1);
            result.put("mapLayerList", layerList);
        }, this.executor);
        CompletableFuture<Void> dangerList = CompletableFuture.runAsync(() -> {
            List<EntDangerDto> dangerListS = this.dangerMapper.getByList(map1);
            result.put("dangerList", dangerListS);
        }, this.executor);
        CompletableFuture<Void> warning = CompletableFuture.runAsync(() -> {
            HashMap<String, Object> map5 = new HashMap<String, Object>(16);
            map5.put("ocId", ocId);
            map5.put("status", 1);
            List<AlertDto> warningList = this.alertMapper.getByList(map5);
            result.put("warningList", warningList);
            result.put("warningTotal", warningList.size());
        }, this.executor);
        CompletableFuture<Void> danger = CompletableFuture.runAsync(() -> {}, this.executor);
        try {
            CompletableFuture.allOf(riskPointCounter, todayTask, mapLayerList, dangerList, warning, danger).get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        return result;
    }
}

