/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.service.impl;

import com.github.pagehelper.PageHelper;
import com.zhyc.xps.aqpt.dto.SnapshotDto;
import com.zhyc.xps.aqpt.entity.Snapshot;
import com.zhyc.xps.aqpt.mapper.SnapshotMapper;
import com.zhyc.xps.aqpt.service.SnapshotService;
import com.zhyc.xps.aqpt.vo.SnapshotVo;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.service.BaseService;
import com.zhyc.xps.common.utils.IdGenerator.IdKit;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SnapshotServiceImpl
extends BaseService
implements SnapshotService {
    @Autowired
    SnapshotMapper snapshotMapper;

    @Override
    public PageBean<SnapshotDto> getSnapshotByPage(Map<String, Object> map) {
        int page = Integer.parseInt("0" + map.get("page"));
        int limit = Integer.parseInt("0" + map.get("limit"));
        PageHelper.startPage((int)page, (int)limit);
        List<SnapshotDto> list = this.snapshotMapper.getByPage(map);
        PageBean pageData = new PageBean(list);
        return pageData;
    }

    @Override
    public SnapshotDto getSnapshotById(Long ocId, Long snapshotId) {
        return this.snapshotMapper.getById(ocId, snapshotId);
    }

    @Override
    public List<SnapshotDto> getSnapshotByList(Map<String, Object> map) {
        return this.snapshotMapper.getByList(map);
    }

    @Override
    public void createSnapshot(Snapshot snapshot) throws Exception {
        snapshot.setSnapshotId(IdKit.getId());
        snapshot.setCreatedAt(LocalDateTime.now());
        this.snapshotMapper.create(snapshot);
    }

    @Override
    public void createSnapshotData(SnapshotVo vo) throws Exception {
        Long ocId = vo.getOcId();
        Long groupId = vo.getGroupId();
        Long userId = vo.getAccountId();
        Long positionId = vo.getPositionId();
        Long snapshotId = IdKit.getId();
        Snapshot snapshot = new Snapshot();
        snapshot.setOcId(ocId);
        snapshot.setSnapshotId(snapshotId);
        snapshot.setSnapshotTitle(vo.getSnapshotTitle());
        snapshot.setSnapshotRemark(vo.getSnapshotRemark());
        snapshot.setStatus(vo.getStatus());
        snapshot.setSubmitGroupId(groupId);
        snapshot.setSubmitAccountId(userId);
        snapshot.setSubmitTime(LocalDateTime.now());
        snapshot.setCreatedAt(LocalDateTime.now());
        snapshot.setCreatedBy(userId);
        this.snapshotMapper.create(snapshot);
    }

    @Override
    public void updateSnapshotData(SnapshotVo vo) throws Exception {
        Long ocId = vo.getOcId();
        Long groupId = vo.getGroupId();
        Long userId = vo.getAccountId();
        Long snapshotId = vo.getSnapshotId();
        Long positionId = vo.getPositionId();
        Snapshot snapshot = new Snapshot();
        snapshot.setOcId(ocId);
        snapshot.setSnapshotId(snapshotId);
        snapshot.setSnapshotTitle(vo.getSnapshotTitle());
        snapshot.setSnapshotRemark(vo.getSnapshotRemark());
        snapshot.setHandleGroupId(groupId);
        snapshot.setHandleAccountId(userId);
        snapshot.setHandleTime(LocalDateTime.now());
        snapshot.setUpdatedAt(LocalDateTime.now());
        snapshot.setUpdatedBy(userId);
        this.snapshotMapper.update(snapshot);
    }

    @Override
    public void updateSnapshot(Snapshot snapshot) throws Exception {
        snapshot.setUpdatedAt(LocalDateTime.now());
        this.snapshotMapper.update(snapshot);
    }

    @Override
    public void updateSnapshotStatus(Long ocId, Long snapshotId, Long status) throws Exception {
        SnapshotDto snapshotDto = this.snapshotMapper.getById(ocId, snapshotId);
        if (snapshotDto != null) {
            Snapshot snapshot = new Snapshot();
            snapshot.setOcId(ocId);
            snapshot.setSnapshotId(snapshotId);
            snapshot.setStatus(status);
            snapshot.setUpdatedAt(LocalDateTime.now());
            this.snapshotMapper.update(snapshot);
        }
    }

    @Override
    public void deleteSnapshot(Map<String, Object> map) throws Exception {
        map.put("deletedAt", LocalDateTime.now());
        map.put("deletedFlag", 1);
        this.snapshotMapper.delete(map);
    }

    @Override
    public void deleteSnapshotById(Long ocId, Long snapshotId) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("deletedAt", LocalDateTime.now());
        map.put("deletedFlag", 1);
        map.put("ocId", ocId);
        map.put("snapshotId", snapshotId);
        this.snapshotMapper.delete(map);
    }
}

