/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.common.config;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.util.Date;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@ConfigurationProperties(prefix="config.jwt")
@Component
public class JwtConfig {
    private String secret;
    private long expire;
    private String header;
    private String tokenHead;

    public String getToken(String identityId) {
        Date nowDate = new Date();
        Date expireDate = new Date(nowDate.getTime() + this.expire * 1000L);
        return Jwts.builder().setHeaderParam("typ", (Object)"JWT").setSubject(identityId).setIssuedAt(nowDate).setExpiration(expireDate).signWith(SignatureAlgorithm.HS256, this.secret).compact();
    }

    public Claims getTokenClaim(String token) {
        try {
            return (Claims)Jwts.parser().setSigningKey(this.secret).parseClaimsJws(token).getBody();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isTokenExpired(Date expirationTime) {
        return expirationTime.before(new Date());
    }

    public String getTokenHead() {
        return this.tokenHead;
    }

    public void setTokenHead(String tokenHead) {
        this.tokenHead = tokenHead;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public long getExpire() {
        return this.expire;
    }

    public void setExpire(long expire) {
        this.expire = expire;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }
}

