/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.common.config;

import com.zhyc.xps.common.interceptor.AppKeyInterceptor;
import com.zhyc.xps.common.interceptor.TokenInterceptor;
import com.zhyc.xps.common.spring.interceptor.LogInterceptor;
import jakarta.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.filter.FormContentFilter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class MyWebAppConfigurer
implements WebMvcConfigurer {
    @Value(value="upload/*.*")
    private String uploadPath;
    @Value(value="${upload.url}")
    private String uploadUrl;
    @Resource
    private AppKeyInterceptor appKeyInterceptor;
    @Resource
    private TokenInterceptor tokenInterceptor;

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**").allowedOriginPatterns(new String[]{"*"}).allowCredentials(true).allowedHeaders(new String[]{"*"}).allowedMethods(new String[]{"GET", "POST", "PUT", "DELETE", "PATCH"});
    }

    @Bean
    public FormContentFilter formContentFilter() {
        return new FormContentFilter();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new LogInterceptor()).addPathPatterns(new String[]{"/**"}).excludePathPatterns(new String[]{"/login"}).excludePathPatterns(new String[]{"/admin/login"});
        registry.addInterceptor((HandlerInterceptor)this.appKeyInterceptor).addPathPatterns(new String[]{"/**"});
        String[] exclude = new String[]{"/login", this.uploadPath};
        registry.addInterceptor((HandlerInterceptor)this.tokenInterceptor).addPathPatterns(new String[]{"/**"}).excludePathPatterns(exclude);
        super.addInterceptors(registry);
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{this.uploadPath}).addResourceLocations(new String[]{"file:" + this.uploadPath});
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addViewController("/error/404").setViewName("/admin/page_error/error_404.html");
    }
}

