/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.common.fdfd;

import cn.hutool.core.io.FileTypeUtil;
import com.github.tobato.fastdfs.domain.fdfs.StorePath;
import com.github.tobato.fastdfs.domain.fdfs.ThumbImageConfig;
import com.github.tobato.fastdfs.domain.upload.FastFile;
import com.github.tobato.fastdfs.exception.FdfsUnsupportStorePathException;
import com.github.tobato.fastdfs.service.FastFileStorageClient;
import com.zhyc.xps.common.entity.FileBean;
import com.zhyc.xps.common.utils.StringUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import net.coobird.thumbnailator.Thumbnails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class FastdfsClientUtil {
    private static final Logger log = LoggerFactory.getLogger(FastdfsClientUtil.class);
    @Autowired
    private FastFileStorageClient storageClient;
    @Autowired
    private ThumbImageConfig thumbImageConfig;

    public InputStream scale(MultipartFile file) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Thumbnails.of((InputStream[])new InputStream[]{file.getInputStream()}).scale(1.0).outputQuality(0.5f).toOutputStream((OutputStream)out);
        }
        catch (IOException e) {
            ImageInputStream input = ImageIO.createImageInputStream(file.getInputStream());
            BufferedImage image = ImageIO.read(input);
            ImageOutputStream output = ImageIO.createImageOutputStream(input);
            if (!ImageIO.write((RenderedImage)image, "jpg", output)) {
                log.info("-----cmyk\u8f6c\u5316\u5f02\u5e38:{}-----");
            }
            Thumbnails.of((BufferedImage[])new BufferedImage[]{image}).scale(1.0).outputQuality(0.5f).toOutputStream((OutputStream)out);
            e.printStackTrace();
        }
        return this.parse(out);
    }

    public InputStream scaleThumbnails(MultipartFile file) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Thumbnails.of((InputStream[])new InputStream[]{file.getInputStream()}).scale((double)0.2f).outputQuality(0.2f).toOutputStream((OutputStream)out);
        }
        catch (IOException e) {
            ImageInputStream input = ImageIO.createImageInputStream(file.getInputStream());
            BufferedImage image = ImageIO.read(input);
            ImageOutputStream output = ImageIO.createImageOutputStream(input);
            if (!ImageIO.write((RenderedImage)image, "jpg", output)) {
                log.info("-----cmyk\u8f6c\u5316\u5f02\u5e38:{}-----");
            }
            Thumbnails.of((BufferedImage[])new BufferedImage[]{image}).scale((double)0.2f).outputQuality(0.2f).toOutputStream((OutputStream)out);
            e.printStackTrace();
        }
        return this.parse(out);
    }

    public ByteArrayInputStream parse(OutputStream out) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos = (ByteArrayOutputStream)out;
        ByteArrayInputStream swapStream = new ByteArrayInputStream(baos.toByteArray());
        return swapStream;
    }

    private Boolean isPicture(String fileName) {
        int index = fileName.lastIndexOf(".");
        String suffix = null;
        if (index == -1 || (suffix = fileName.substring(index + 1)).isEmpty()) {
            return false;
        }
        HashSet<String> allowSuffix = new HashSet<String>(Arrays.asList("jpg", "jpeg", "png", "gif"));
        if (allowSuffix.contains(suffix.toLowerCase())) {
            return true;
        }
        return false;
    }

    public FileBean upload(MultipartFile file, FileBean fileBean) throws Exception {
        String fileNameOriginal = file.getOriginalFilename();
        if (this.isPicture(fileNameOriginal).booleanValue()) {
            MockMultipartFile multipartFile = new MockMultipartFile("temp.jpg", "temp.jpg", "", this.scale(file));
            MockMultipartFile scaleThumbnails = new MockMultipartFile("temp.jpg", "temp.jpg", "", this.scaleThumbnails(file));
            StorePath storePath1 = this.storageClient.uploadFile(multipartFile.getInputStream(), multipartFile.getSize(), fileBean.getExt(), null);
            StorePath storePath2 = this.storageClient.uploadFile(scaleThumbnails.getInputStream(), scaleThumbnails.getSize(), fileBean.getExt(), null);
            fileBean.setPath(storePath1.getFullPath());
        } else {
            StorePath storePath = this.storageClient.uploadFile(file.getInputStream(), file.getSize(), fileBean.getExt(), null);
            fileBean.setPath(storePath.getFullPath());
        }
        return fileBean;
    }

    public String upload(MultipartFile file) throws Exception {
        String extName = FileTypeUtil.getType((InputStream)file.getInputStream());
        FastFile fastFile = null;
        String fileNameOriginal = file.getOriginalFilename();
        if (this.isPicture(fileNameOriginal).booleanValue()) {
            MockMultipartFile multipartFile = new MockMultipartFile("temp.jpg", "temp.jpg", "", this.scale(file));
            fastFile = new FastFile.Builder().withFile(multipartFile.getInputStream(), multipartFile.getSize(), extName).build();
        } else {
            fastFile = new FastFile.Builder().withFile(file.getInputStream(), file.getSize(), extName).build();
        }
        StorePath storePath = this.storageClient.uploadFile(fastFile);
        log.info(storePath.toString());
        return storePath.getFullPath();
    }

    public String upload(byte[] bytes, String prefix) throws Exception {
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        StorePath storePath = this.storageClient.uploadFile((InputStream)input, (long)((InputStream)input).available(), prefix, null);
        return storePath.getFullPath();
    }

    public void deleteFile(String fileUrl) {
        if (StringUtils.isEmpty(fileUrl)) {
            return;
        }
        try {
            StorePath storePath = StorePath.parseFromUrl((String)fileUrl);
            this.storageClient.deleteFile(storePath.getGroup(), storePath.getPath());
        }
        catch (FdfsUnsupportStorePathException e) {
            log.warn(e.getMessage());
        }
    }
}

