/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.common.service;

import com.github.pagehelper.PageHelper;
import com.zhyc.xps.common.dto.MsgDetailDto;
import com.zhyc.xps.common.dto.MsgDto;
import com.zhyc.xps.common.entity.Msg;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.mapper.MsgMapper;
import com.zhyc.xps.common.utils.IdGenerator.IdKit;
import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MsgUtilService {
    @Resource
    private MsgMapper msgMapper;

    public PageBean<MsgDto> getMessageByPage(Map<String, Object> map) {
        int page = Integer.parseInt("0" + map.get("page"));
        int limit = Integer.parseInt("0" + map.get("limit"));
        PageHelper.startPage((int)page, (int)limit);
        List<MsgDto> list = this.msgMapper.getByPage(map);
        return new PageBean<MsgDto>(list);
    }

    public List<MsgDto> getMessageByList(Map<String, Object> map) {
        return this.msgMapper.getByList(map);
    }

    public MsgDetailDto getMessageById(Long ocId, Long msgId) {
        return this.msgMapper.getById(ocId, msgId);
    }

    public void create(Msg message) throws Exception {
        Long msgId = IdKit.getId();
        message.setMsgId(msgId);
        message.setMsgTime(LocalDateTime.now());
        message.setCreatedAt(LocalDateTime.now());
        this.msgMapper.create(message);
    }
}

