/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.common.utils;

import com.zhyc.xps.common.entity.Msg;
import com.zhyc.xps.common.mapper.MsgMapper;
import com.zhyc.xps.common.service.MsgUtilService;
import com.zhyc.xps.common.service.SettingUtilService;
import com.zhyc.xps.common.utils.IdGenerator.IdKit;
import com.zhyc.xps.common.utils.StringUtils;
import com.zhyc.xps.common.utils.jpush.JPushKit;
import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;

public class MessageUtil {
    @Value(value="${AppKey}")
    private static String appkey;
    @Value(value="${Master_Secret}")
    private static String masterSecret;
    @Resource
    private static MsgUtilService messageService;

    public static void sendMessage(Long cId, String content, String alert, String msgTo, String detail, String url) throws Exception {
        Msg message = new Msg();
        message.setMsgContent(content);
        message.setMsgDetail(detail);
        message.setMsgCatId(1L);
        message.setOcId(cId);
        message.setMsgTo(msgTo);
        message.setMsgFrId(cId);
        messageService.create(message);
        if (StringUtils.isNotEmpty(appkey) && StringUtils.isNotEmpty(masterSecret)) {
            HashMap<String, String> extras = new HashMap<String, String>();
            extras.put("title", content);
            extras.put("alert", alert);
            extras.put("body", content);
            extras.put("url", url);
            JPushKit.sendPush(appkey, masterSecret, alert, content, msgTo.toString(), extras);
        }
    }

    public static void sendMessageS(String title, String alert, String content, String url, List<Long> aId) {
        if (StringUtils.isNotEmpty(appkey) && StringUtils.isNotEmpty(masterSecret)) {
            HashMap<String, String> extras = new HashMap<String, String>();
            extras.put("title", title);
            extras.put("alert", alert);
            extras.put("body", content);
            extras.put("url", url);
        }
    }

    public static void sendMessage(Long ocId, String content, String msgTo, String detail, MsgMapper messageDao, SettingUtilService settingsService) throws Exception {
        Msg message = new Msg();
        message.setMsgId(IdKit.getId());
        message.setMsgContent(content);
        message.setMsgDetail(detail);
        message.setOcId(ocId);
        message.setMsgTo(msgTo);
        message.setMsgCatId(1L);
        message.setStatus(0L);
        message.setMsgTime(LocalDateTime.now());
        messageDao.create(message);
        if (settingsService != null) {
            HashMap<String, String> extras = new HashMap<String, String>();
            extras.put("msgId", String.valueOf(message.getMsgId()));
            extras.put("content", content);
            extras.put("body", content);
        }
    }

    public static void sendChatMessage(Integer msgId, String content, Long msgTo, String detail, SettingUtilService settingsService) throws Exception {
        if (settingsService != null) {
            HashMap<String, String> extras = new HashMap<String, String>();
            extras.put("msgId", String.valueOf(msgId));
            extras.put("content", content);
            extras.put("body", detail);
            JPushKit.sendPush(settingsService, content, msgTo, extras);
        }
    }

    public static void sendAllChatMessage(Integer msgId, String title, List<Long> aId, String content, SettingUtilService settingsService) throws Exception {
        if (settingsService != null) {
            HashMap<String, String> extras = new HashMap<String, String>();
            extras.put("msgId", String.valueOf(msgId));
            extras.put("title", title);
            extras.put("body", content);
            JPushKit.sendPush(settingsService, title, extras, aId);
        }
    }

    public static void sendAllChatMessage(Integer msgId, String title, List<Long> aId, String content, SettingUtilService settingsService, int flag) throws Exception {
        if (settingsService != null) {
            HashMap<String, String> extras = new HashMap<String, String>();
            extras.put("msgId", String.valueOf(msgId));
            extras.put("title", title);
            extras.put("body", content);
            JPushKit.sendPush(settingsService, title, extras, aId, flag);
        }
    }
}

