/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.common.utils.jpush;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.jiguang.common.ClientConfig;
import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jpush.api.JPushClient;
import cn.jpush.api.push.PushResult;
import cn.jpush.api.push.model.Options;
import cn.jpush.api.push.model.Platform;
import cn.jpush.api.push.model.PushPayload;
import cn.jpush.api.push.model.audience.Audience;
import cn.jpush.api.push.model.notification.AndroidNotification;
import cn.jpush.api.push.model.notification.IosAlert;
import cn.jpush.api.push.model.notification.IosNotification;
import cn.jpush.api.push.model.notification.Notification;
import cn.jpush.api.push.model.notification.PlatformNotification;
import com.zhyc.xps.common.entity.Setting;
import com.zhyc.xps.common.service.SettingUtilService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPushKit {
    private static final Logger log = LoggerFactory.getLogger(JPushKit.class);
    protected static final String USER_PREFIX = "push";
    protected static final String GROUP_PREFIX = "g";
    private static final String USER_PREFIX_ORG = "SCYF";
    private static final String USER_PREFIX_GROUP = "EP";
    public static final String JPUSH_APP_KEY = "jpush_app_key";
    public static final String JPUSH_MASTER_SECRET = "jpush_master_secret";
    private static final String JPUSH_APP_KEY_GROUP = "group_app_key";
    private static final String JPUSH_MASTER_SECRET_GROUP = "group_app_master_secret";
    private static final String JPUSH_APP_KEY_ORG = "org_app_key";
    private static final String JPUSH_MASTER_SECRET_ORG = "org_app_master_secret";
    private static final int SEND_EACH_TIME = 1000;
    protected static final String APP_KEY = "be03e2a6fe01894ddc0802c6";
    protected static final String MASTER_SECRET = "16b43829dd5f9f9c47787ac5";
    public static final String ALERT = "\u5c0f\u96f7\u3002\u3002\u3002\u3002\u3002\u3002\u3002";

    public static void main(String[] args) {
        HashMap<String, String> extras = new HashMap<String, String>();
        extras.put("id", "123");
        extras.put("title", "123");
        extras.put("body", "123");
        String registrationId = "24718";
        JPushKit.sendPush(APP_KEY, MASTER_SECRET, ALERT, registrationId, extras);
    }

    public static Integer sendPush(SettingUtilService settingService, String alert, Map<String, String> extras, List<Long> aId) {
        Setting appKey = settingService.getSettingByKey(JPUSH_APP_KEY);
        Setting masterSecret = settingService.getSettingByKey(JPUSH_MASTER_SECRET);
        if (appKey == null || masterSecret == null) {
            return 0;
        }
        return JPushKit.sendPushList(appKey.getSettingValue(), masterSecret.getSettingValue(), alert, extras, aId);
    }

    public static Integer sendPush(SettingUtilService settingService, String alert, Map<String, String> extras, List<Long> aId, int flag) {
        Setting masterSecret;
        Setting appKey;
        if (flag == 1) {
            appKey = settingService.getSettingByKey(JPUSH_APP_KEY_ORG);
            masterSecret = settingService.getSettingByKey(JPUSH_MASTER_SECRET_ORG);
        } else {
            appKey = settingService.getSettingByKey(JPUSH_APP_KEY_GROUP);
            masterSecret = settingService.getSettingByKey(JPUSH_MASTER_SECRET_GROUP);
        }
        if (appKey == null || masterSecret == null) {
            return 0;
        }
        return JPushKit.sendPushList(appKey.getSettingValue(), masterSecret.getSettingValue(), alert, extras, aId, flag);
    }

    public static Integer sendPush(SettingUtilService settingsService, String alert, Long aId, Map<String, String> extras) {
        Setting appKey = settingsService.getSettingByKey(JPUSH_APP_KEY);
        Setting masterSecret = settingsService.getSettingByKey(JPUSH_MASTER_SECRET);
        if (appKey == null || masterSecret == null) {
            return 0;
        }
        return JPushKit.sendPush(appKey.getSettingValue(), masterSecret.getSettingValue(), alert, String.valueOf(aId), extras);
    }

    public static Integer sendPushList(String appKey, String masterSecret, String alert, Map<String, String> extras, List<Long> aId, int flag) {
        ClientConfig clientConfig = ClientConfig.getInstance();
        JPushClient jpushClient = new JPushClient(masterSecret, appKey, null, clientConfig);
        PushPayload payload = null;
        try {
            if (aId != null && extras != null) {
                return JPushKit.sendPushAIdList(jpushClient, aId, alert, extras, flag);
            }
            payload = StrUtil.isNotEmpty((CharSequence)alert) && extras != null ? JPushKit.buildPushObject(alert, extras) : JPushKit.buildPushObject(alert);
            PushResult result = jpushClient.sendPush(payload);
            int status = result.getResponseCode();
            if (status == 200) {
                log.info("\u63a8\u9001\u6210\u529f - " + result);
                return 1;
            }
            log.info("Got result - " + result);
        }
        catch (APIConnectionException e) {
            log.error("Connection error. Should retry later. ", (Throwable)e);
            log.error("Sendno: " + payload.getSendno());
        }
        catch (APIRequestException e) {
            log.error("Error response from JPush server. Should review and fix it. ", (Throwable)e);
            log.info("HTTP Status: " + e.getStatus());
            log.info("Error Code: " + e.getErrorCode());
            log.info("Error Message: " + e.getErrorMessage());
            log.info("Msg ID: " + e.getMsgId());
            log.error("Sendno: " + payload.getSendno());
        }
        return 0;
    }

    public static Integer sendPushAIdList(JPushClient jpushClient, List<Long> aId, String alert, Map<String, String> extras, int flag) throws APIConnectionException, APIRequestException {
        if (CollectionUtil.isNotEmpty(aId)) {
            StringBuilder prefix = new StringBuilder();
            if (flag == 1) {
                prefix.append(USER_PREFIX_ORG);
            } else {
                prefix.append(USER_PREFIX_GROUP);
            }
            int totalSize = aId.size();
            int mode = totalSize % 1000;
            int sendTimes = totalSize / 1000;
            if (mode > 0) {
                ++sendTimes;
            }
            ArrayList<String> accountIds = new ArrayList<String>();
            for (int i = 0; i < sendTimes; ++i) {
                int start = i * 1000;
                int end = i == sendTimes - 1 && mode > 0 ? start + mode - 1 : start + 1000 - 1;
                for (int j = start; j <= end; ++j) {
                    accountIds.add(prefix + aId.get(j).toString());
                }
                PushPayload payload = JPushKit.buildPushObject(accountIds, alert, extras);
                PushResult result = jpushClient.sendPush(payload);
                int status = result.getResponseCode();
                if (status == 200) {
                    log.info("\u63a8\u9001\u6210\u529f - " + result);
                } else {
                    log.info("\u63a8\u9001\u5931\u8d25 - " + result);
                }
                accountIds.clear();
            }
            return 1;
        }
        return 0;
    }

    public static Integer sendPushList(String appKey, String masterSecret, String alert, Map<String, String> extras, List<Long> aId) {
        ClientConfig clientConfig = ClientConfig.getInstance();
        JPushClient jpushClient = new JPushClient(masterSecret, appKey, null, clientConfig);
        PushPayload payload = null;
        try {
            if (aId != null && extras != null) {
                return JPushKit.sendPushAIdList(jpushClient, aId, alert, extras);
            }
            payload = StrUtil.isNotEmpty((CharSequence)alert) && extras != null ? JPushKit.buildPushObject(alert, extras) : JPushKit.buildPushObject(alert);
            PushResult result = jpushClient.sendPush(payload);
            int status = result.getResponseCode();
            if (status == 200) {
                log.info("\u63a8\u9001\u6210\u529f - " + result);
                return 1;
            }
            log.info("Got result - " + result);
        }
        catch (APIConnectionException e) {
            log.error("Connection error. Should retry later. ", (Throwable)e);
            log.error("Sendno: " + payload.getSendno());
        }
        catch (APIRequestException e) {
            log.error("Error response from JPush server. Should review and fix it. ", (Throwable)e);
            log.info("HTTP Status: " + e.getStatus());
            log.info("Error Code: " + e.getErrorCode());
            log.info("Error Message: " + e.getErrorMessage());
            log.info("Msg ID: " + e.getMsgId());
            log.error("Sendno: " + payload.getSendno());
        }
        return 0;
    }

    public static Integer sendPushAIdList(JPushClient jpushClient, List<Long> aId, String alert, Map<String, String> extras) throws APIConnectionException, APIRequestException {
        ArrayList<String> accountIds = new ArrayList<String>();
        if (aId.size() < 1000) {
            ArrayList<String> finalAccountIds = accountIds;
            aId.forEach(e -> finalAccountIds.add(USER_PREFIX.concat(e.toString())));
            PushPayload payload = null;
            payload = JPushKit.buildPushObject(accountIds, alert, extras);
            PushResult result = jpushClient.sendPush(payload);
            int status = result.getResponseCode();
            if (status == 200) {
                log.info("\u63a8\u9001\u6210\u529f - " + result);
                return 1;
            }
            log.info("Got result - " + result);
        } else {
            for (int i = 0; i < aId.size(); ++i) {
                accountIds.add(USER_PREFIX.concat(aId.get(i).toString()));
                if (i % 1000 != 0) continue;
                PushPayload payload = null;
                payload = JPushKit.buildPushObject(accountIds, alert, extras);
                PushResult result = jpushClient.sendPush(payload);
                int status = result.getResponseCode();
                if (status == 200) {
                    log.info("\u63a8\u9001\u6210\u529f - " + result);
                } else {
                    log.info("Got result - " + result);
                }
                accountIds = new ArrayList();
            }
        }
        return 0;
    }

    public static Integer sendPush(String appKey, String masterSecret, String alert, String title, String aId, Map<String, String> extras) {
        ClientConfig clientConfig = ClientConfig.getInstance();
        JPushClient jpushClient = new JPushClient(masterSecret, appKey, null, clientConfig);
        PushPayload payload = StrUtil.isNotEmpty((CharSequence)alert) && StrUtil.isNotEmpty((CharSequence)aId) && extras != null ? JPushKit.buildPushObject(aId, alert, title, extras) : (StrUtil.isNotEmpty((CharSequence)alert) && extras != null ? JPushKit.buildPushObject(alert, extras) : JPushKit.buildPushObject(alert));
        try {
            PushResult result = jpushClient.sendPush(payload);
            int status = result.getResponseCode();
            if (status == 200) {
                log.info("\u63a8\u9001\u6210\u529f - " + result);
                return 1;
            }
            log.info("Got result - " + result);
        }
        catch (APIConnectionException e) {
            log.error("Connection error. Should retry later. ", (Throwable)e);
            log.error("Sendno: " + payload.getSendno());
        }
        catch (APIRequestException e) {
            log.error("Error response from JPush server. Should review and fix it. ", (Throwable)e);
            log.info("HTTP Status: " + e.getStatus());
            log.info("Error Code: " + e.getErrorCode());
            log.info("Error Message: " + e.getErrorMessage());
            log.info("Msg ID: " + e.getMsgId());
            log.error("Sendno: " + payload.getSendno());
        }
        return 0;
    }

    public static PushPayload buildPushObject(List<String> accountIds, String alert, Map<String, String> extras) {
        IosAlert iosAlert = IosAlert.newBuilder().setTitleAndBody(extras.get("title"), null, extras.get("body")).build();
        extras.remove("title");
        extras.remove("body");
        return PushPayload.newBuilder().setPlatform(Platform.android_ios()).setAudience(Audience.alias(accountIds)).setNotification(Notification.newBuilder().addPlatformNotification((PlatformNotification)((AndroidNotification.Builder)AndroidNotification.newBuilder().setAlert((Object)alert).setTitle(alert).addExtras(extras)).build()).addPlatformNotification((PlatformNotification)((IosNotification.Builder)IosNotification.newBuilder().setAlert((Object)iosAlert).addExtras(extras)).setSound((Object)"default").build()).build()).setOptions(Options.newBuilder().setApnsProduction(false).setTimeToLive(86000L).build()).build();
    }

    public static PushPayload buildPushObject(String accountId, String alert, String title, Map<String, String> extras) {
        IosAlert iosAlert = IosAlert.newBuilder().setTitleAndBody(extras.get("title"), null, extras.get("body")).build();
        extras.remove("title");
        extras.remove("body");
        return PushPayload.newBuilder().setPlatform(Platform.android_ios()).setAudience(Audience.alias((String[])new String[]{USER_PREFIX.concat(accountId)})).setNotification(Notification.newBuilder().addPlatformNotification((PlatformNotification)((AndroidNotification.Builder)AndroidNotification.newBuilder().setAlert((Object)alert).setTitle(title).addExtras(extras)).build()).addPlatformNotification((PlatformNotification)((IosNotification.Builder)IosNotification.newBuilder().setAlert((Object)iosAlert).addExtras(extras)).setSound((Object)"default").build()).build()).setOptions(Options.newBuilder().setApnsProduction(false).setTimeToLive(86000L).build()).build();
    }

    public static Integer sendPush(String appKey, String masterSecret, String alert, String aId, Map<String, String> extras) {
        ClientConfig clientConfig = ClientConfig.getInstance();
        JPushClient jpushClient = new JPushClient(masterSecret, appKey, null, clientConfig);
        PushPayload payload = StrUtil.isNotEmpty((CharSequence)alert) && StrUtil.isNotEmpty((CharSequence)aId) && extras != null ? JPushKit.buildPushObject(aId, alert, extras) : (StrUtil.isNotEmpty((CharSequence)alert) && extras != null ? JPushKit.buildPushObject(alert, extras) : JPushKit.buildPushObject(alert));
        try {
            PushResult result = jpushClient.sendPush(payload);
            int status = result.getResponseCode();
            if (status == 200) {
                log.info("\u63a8\u9001\u6210\u529f - " + result);
                return 1;
            }
            log.info("Got result - " + result);
        }
        catch (APIConnectionException e) {
            log.error("Connection error. Should retry later. ", (Throwable)e);
            log.error("Sendno: " + payload.getSendno());
        }
        catch (APIRequestException e) {
            log.error("Error response from JPush server. Should review and fix it. ", (Throwable)e);
            log.info("HTTP Status: " + e.getStatus());
            log.info("Error Code: " + e.getErrorCode());
            log.info("Error Message: " + e.getErrorMessage());
            log.info("Msg ID: " + e.getMsgId());
            log.error("Sendno: " + payload.getSendno());
        }
        return 0;
    }

    public static PushPayload buildPushObject(String accountId, String alert, Map<String, String> extras) {
        IosAlert iosAlert = IosAlert.newBuilder().setTitleAndBody(extras.get("title"), null, extras.get("body")).build();
        extras.remove("title");
        extras.remove("body");
        return PushPayload.newBuilder().setPlatform(Platform.android_ios()).setAudience(Audience.alias((String[])new String[]{USER_PREFIX.concat(accountId)})).setNotification(Notification.newBuilder().addPlatformNotification((PlatformNotification)((AndroidNotification.Builder)AndroidNotification.newBuilder().setAlert((Object)alert).setTitle(alert).addExtras(extras)).build()).addPlatformNotification((PlatformNotification)((IosNotification.Builder)IosNotification.newBuilder().setAlert((Object)iosAlert).addExtras(extras)).setSound((Object)"default").build()).build()).setOptions(Options.newBuilder().setApnsProduction(false).setTimeToLive(86000L).build()).build();
    }

    public static PushPayload buildPushObject(String alert) {
        return PushPayload.newBuilder().setPlatform(Platform.all()).setAudience(Audience.all()).setNotification(Notification.alert((Object)alert)).setOptions(Options.newBuilder().setApnsProduction(false).setTimeToLive(86000L).build()).build();
    }

    public static PushPayload buildPushObject(String alert, Map<String, String> extras) {
        return PushPayload.newBuilder().setPlatform(Platform.android_ios()).setAudience(Audience.all()).setNotification(Notification.newBuilder().addPlatformNotification((PlatformNotification)((AndroidNotification.Builder)AndroidNotification.newBuilder().setAlert((Object)alert).setTitle(alert).addExtras(extras)).build()).addPlatformNotification((PlatformNotification)((IosNotification.Builder)IosNotification.newBuilder().setAlert((Object)alert).addExtras(extras)).setSound((Object)"default").build()).build()).setOptions(Options.newBuilder().setApnsProduction(false).setTimeToLive(86000L).build()).build();
    }
}

